select
    *
from
    (
        select
            h.id,
            h.f_user_id,
            h.f_whether_pay,
            h.f_oughtfee,
            h.f_input_date,
            h.f_orgid,
            h.f_oughtamount,
            h.f_hand_state,
            h.f_userinfo_code,
            h.f_user_name,
            h.f_meternumber,
            h.f_last_tablebase,
            h.f_tablebase,
            h.f_balance,
            h.f_curbalance,
            h.f_hand_date,
            h.f_inputtor,
            h.f_input_person,
            h.f_meter_state,
            h.f_result_state,
            h.f_orgname,
            h.f_depname,
            h.f_operator,
            hd.f_stair1fee,
            hd.f_stair2fee,
            hd.f_stair3fee,
            hd.f_stair1price,
            hd.f_stair2price,
            hd.f_stair3price,
            hd.f_stairamount1,
            hd.f_stair2amount,
            hd.f_stair3amount,
            hd.f_detailprice,
            case when f_last_input_date is null then
            {
                entity.findDialect() == $SqlServer$:
                    $
                        isnull(CONVERT (VARCHAR (7),f_hand_date, 121 ) ,
                        CONVERT(VARCHAR (7),f_hand_date, 121 ))+ '--' + isnull(CONVERT(VARCHAR (7),f_input_date, 121 ) ,
                        CONVERT(VARCHAR (7),f_hand_date, 121 ))
                        when f_last_input_date is not null
                        then CONVERT(VARCHAR (7), f_hand_date, 121) + '--' +
                        isnull(CONVERT(VARCHAR (7), f_input_date, 121),
                        CONVERT(VARCHAR (7), f_hand_date, 121))
                    $,
                    $
                        isnull(substr(to_char(f_hand_date,'yyyy-mm-dd hh24:mi:ss'),0,7) ,
                        substr(to_char(f_hand_date,'yyyy-mm-dd hh24:mi:ss'),0,7)) || '--' ||
                        isnull(substr(to_char(f_input_date,'yyyy-mm-dd hh24:mi:ss'),0,7) ,
                        substr(to_char(f_hand_date,'yyyy-mm-dd hh24:mi:ss'),0,7))
                        when f_last_input_date is not null
                        then substr(to_char(f_hand_date, 'yyyy-mm-dd hh24:mi:ss'), 0, 7) || '--' || isnull(
                        substr(to_char(f_input_date, 'yyyy-mm-dd hh24:mi:ss'), 0, 7),
                        substr(to_char(f_hand_date, 'yyyy-mm-dd hh24:mi:ss'), 0, 7))
                    $
            } end datas,
            f_oughtfee as f_oughtfee1,      -- 应交金额
            '0' as money1,                  -- 滞纳金
            '阶梯价' as price1                 -- 单价
        from
            t_handplan h
            left join (
                select
                    f_hand_id,
                    { entity.findDialect() == $SqlServer$:
                        $(
                            select
                                cast (f_price as varchar) + 'X' + cast (f_gas as varchar) + '|'
                            from
                                t_chargeprice
                            where
                                f_hand_id=s.f_hand_id
                            for xml path ('')
                        )$,
                        $(
                            select
                                LISTAGG(f_price || 'X' || f_gas, '|') WITHIN GROUP ( ORDER BY f_hand_id)  VALUE
                            FROM
                                t_chargeprice
                            where
                                f_hand_id=s.f_hand_id
                        )$
                    } f_detailprice,
                    CONVERT (decimal (18, 2), sum (f_stairamount1)) f_stairamount1,
                    CONVERT (decimal (18, 2), sum (f_stair1price)) f_stair1price,
                    CONVERT (decimal (18, 2), sum (f_stair1fee)) f_stair1fee,
                    CONVERT (decimal (18, 2), sum (f_stair2amount)) f_stair2amount,
                    CONVERT (decimal (18, 2), sum (f_stair2price)) f_stair2price,
                    CONVERT (decimal (18, 2), sum (f_stair2fee)) f_stair2fee,
                    CONVERT (decimal (18, 2), sum (f_stair3amount)) f_stair3amount,
                    CONVERT (decimal (18, 2), sum (f_stair3price)) f_stair3price, CONVERT (decimal (18, 2), sum (f_stair3fee)) f_stair3fee
                from (
                    select
                        f_hand_id f_hand_id,
                        sum (case f_price_name when '阶梯1' then f_gas when '固定气价' then f_gas else 0 end) f_stairamount1,
                        case f_price_name when '阶梯1' then f_price when '固定气价' then f_price else 0 end f_stair1price,
                        sum (case f_price_name when '阶梯1' then f_money when '固定气价' then f_money else 0 end) f_stair1fee,
                        sum (case f_price_name when '阶梯2' then f_gas else 0 end) f_stair2amount,
                        case f_price_name when '阶梯2' then f_price else 0 end f_stair2price,
                        sum (case f_price_name when '阶梯2' then f_money else 0 end) f_stair2fee,
                        sum (case f_price_name when '阶梯3' then f_gas else 0 end) f_stair3amount,
                        case f_price_name when '阶梯3' then f_price else 0 end f_stair3price,
                        sum (case f_price_name when '阶梯3' then f_money else 0 end) f_stair3fee
                    from
                        t_chargeprice
                    where
                        1=1
                        and f_user_id = '{f_user_id}'
                        and f_hand_id is not null
                    group by f_hand_id, f_price_name, f_price
                ) s
                group by f_hand_id
            ) hd on hd.f_hand_id = h.id
            left join (
                select
                    f_hand_id,
                    sum(f_debt_money)   f_debt_money,
                    sum(f_charge_money) f_charge_money
                from
                    t_sellinghand
                where
                    f_state = '有效'
                group by f_hand_id
            ) sh on h.id = sh.f_hand_id
        where
            f_user_id = '{f_user_id}'
        union all
        select
            h.id,
            h.f_user_id,
            '是' f_whether_pay,
            h.f_oughtfee,
            h.f_input_date,
            h.f_orgid,
            h.f_oughtamount,
            h.f_hand_state,
            h.f_userinfo_code,
            h.f_user_name,
            h.f_meternumber,
            h.f_last_tablebase,
            h.f_tablebase,
            h.f_balance,
            h.f_curbalance,
            h.f_hand_date,
            h.f_inputtor,
            h.f_input_person,
            h.f_meter_state,
            '正常' f_result_state,
            h.f_orgname,
            h.f_depname,
            h.f_operator,
            h.f_stair_money1 f_stair1fee,
            h.f_stair_money2 f_stair2fee,
            h.f_stair_money3 f_stair3fee,
            h.f_stair_price1 f_stair1price,
            h.f_stair_price2 f_stair2price,
            h.f_stair_price3 f_stair3price,
            h.f_stair_gas1 f_stairamount1,
            h.f_stair_gas2 f_stair2amount,
            h.f_stair_gas3 f_stair3amount,
            cast(h.f_stair_price1 as varchar) + 'X' + cast(h.f_stair_gas1 as varchar) + '|' +
            cast(h.f_stair_price2 as varchar) + 'X' + cast(h.f_stair_gas2 as varchar) + '|' +
            cast(h.f_stair_price2 as varchar) + 'X' + cast(h.f_stair_gas2 as varchar) f_detailprice,
            case when f_last_input_date is null then
            {
                entity.findDialect() == $SqlServer$:
                    $
                        isnull(CONVERT (VARCHAR (7),f_hand_date, 121 ) ,CONVERT(VARCHAR (7),f_hand_date, 121 ))+ '--' +
                        isnull(CONVERT(VARCHAR (7),f_input_date, 121 ) ,CONVERT(VARCHAR (7),f_hand_date, 121 ))
                        when f_last_input_date is not null then CONVERT(VARCHAR (7), f_hand_date, 121) + '--' +
                        isnull(CONVERT(VARCHAR (7), f_input_date, 121),
                        CONVERT(VARCHAR (7), f_hand_date, 121))
                    $,
                    $
                        isnull(substr(to_char(f_hand_date,'yyyy-mm-dd hh24:mi:ss'),0,7) ,
                        substr(to_char(f_hand_date,'yyyy-mm-dd hh24:mi:ss'),0,7)) || '--' ||
                        isnull(substr(to_char(f_input_date,'yyyy-mm-dd hh24:mi:ss'),0,7) ,substr(to_char(f_hand_date,'yyyy-mm-dd hh24:mi:ss'),0,7))
                        when f_last_input_date is not null then substr(to_char(f_hand_date, 'yyyy-mm-dd hh24:mi:ss'), 0, 7) ||
                        '--' || isnull(substr(to_char(f_input_date, 'yyyy-mm-dd hh24:mi:ss'), 0, 7),
                        substr(to_char(f_hand_date, 'yyyy-mm-dd hh24:mi:ss'), 0, 7))
                    $
            } end datas,
            f_oughtfee f_oughtfee1, -- 应交金额
            '0' money1,             -- 滞纳金
            '阶梯价' price1        -- 单价
        from
            t_web_handplan h
        where
            f_user_id = '{f_user_id}'
    ) t
where { condition }
