SELECT
	*,
    -- 获取调价前的补差气量
    case when  '{f_change_date}' = '1911-01-01' then 0
    when '{f_change_date}'>=f_last_input_date and  '{f_change_date}'<=f_input_date then
             cast(f_pregas/f_dd*datediff(DD,f_last_input_date,'{f_change_date}')as decimal(10,2))
    else 0 end as startpregas,
    -- 获取调价前的天数
    case when  '{f_change_date}' = '1911-01-01' then 0
    when '{f_change_date}'>=f_last_input_date and  '{f_change_date}'<=f_input_date then
        datediff(DD,f_last_input_date,'{f_change_date}')
    else 0   end  startday,
    -- 获取调价后的气量
    case when  '{f_change_date}' = '1911-01-01' then 0
	when f_last_input_date>='{f_change_date}' then f_pregas
    when '{f_change_date}'>=f_last_input_date and  '{f_change_date}'<=f_input_date then
        cast(f_pregas/f_dd*datediff(DD,'{f_change_date}',f_input_date) as decimal(10,2))
    else 0 end endpregas,
    -- 获取调价后的天数
    case when  '{f_change_date}' = '1911-01-01' then 0
	when f_last_input_date>='{f_change_date}' then datediff(DD,f_last_input_date,f_input_date)
    when '{f_change_date}'>=f_last_input_date and  '{f_change_date}'<=f_input_date then
        datediff(DD,'{f_change_date}',f_input_date)
    else 0 end endday,
    -- 获取平均补差气量
    case when f_pregas = 0 then 0
    else cast(f_pregas/f_dd as decimal(10,2))
    end avgpregas
FROM (
(SELECT
    u2.f_filialeid,
	u4.f_userinfo_id,
	u4.f_userinfo_code,
	u4.f_user_name,
	u4.f_user_phone,
	u3.f_address,
	u2.f_user_type,
	u2.f_gasproperties,
	u2.f_total_gas,
	u2.f_user_id,
	u2.f_userfiles_id,
	u2.f_meter_base,
	u1.f_source,
	u1.f_meter_type,
	u1.f_stairprice_id,
	u1.f_handplan_id,
	u1.f_meter_brand,
	u1.f_meter_style,
	u1.f_last_input_date,
  u1.f_input_date,
	case when case when datediff(DD,u1.f_last_input_date,u1.f_input_date) is null then 1 else datediff(DD,u1.f_last_input_date,u1.f_input_date) end = 0
	then 1 else case when datediff(DD,u1.f_last_input_date,u1.f_input_date) is null then 1 else datediff(DD,u1.f_last_input_date,u1.f_input_date) end end f_dd,
	u2.f_price_id,
	u2.f_meternumber,
	u1.pregas as f_pregas,
	sp1.f_price_name,
	dp1.f_price,
	isnull(f_old_price,0) f_old_price,
	isnull(u1.f_new_price,0) f_new_price,
	u1.f_change_price,
	u1.f_surplus_fee,
	u1.f_last_tablebase,
	u1.f_tablebase,
    met.f_book_slice_area,
    s.f_change_date f_change_date,
    s.f_changetime_type,
    s.f_operate_date,
    u1.f_inputtor,
    u2.f_meter_book_num
FROM
	(
		SELECT
		  id as f_handplan_id,
			f_userfiles_id,
			f_userinfo_id,
			f_meter_brand,
			case when
		    case when f_last_input_date is null
			then
				(select max(f_input_date) from t_handplan where f_userfiles_id = t_handplan.f_userfiles_id and id<t_handplan.id AND f_meter_state = '已抄表' AND f_hand_state = '有效')
			else f_last_input_date end  is null then
                     f_hand_date
			else
                case when f_last_input_date is null
                         then
                         (select max(f_input_date) from t_handplan where f_userfiles_id = t_handplan.f_userfiles_id and id<t_handplan.id AND f_meter_state = '已抄表' AND f_hand_state = '有效')
                     else f_last_input_date end end
                f_last_input_date,
			f_input_date,
			f_meter_style,
			f_price_id,
			f_stairprice_id,
			f_meter_classify f_meter_type,
			f_oughtamount as pregas,
			'机表抄表' f_source,
			isnull(f_new_price,0) f_new_price,
			f_change_price,
			f_surplus_fee,
			f_last_tablebase,
			f_tablebase,
		    f_inputtor
		FROM
			t_handplan
		WHERE
			f_input_date BETWEEN '{startDate} 00:00:00'
		AND '{endDate} 23:59:59'
		AND f_meter_state = '已抄表'
		AND f_hand_state = '有效'
		and f_meter_classify='机表'
	) u1
LEFT JOIN t_userfiles u2 ON u1.f_userfiles_id = u2.f_userfiles_id
LEFT JOIN t_user_address u3 ON u2.f_useraddress_id = u3.id
LEFT JOIN (
    select f_price_id,id,f_price_name,
      f_price_type,id f_stairprice_id
    from t_stairprice where f_perform_date<=GETDATE() and f_end_date>GETDATE()) sp ON u2.f_price_id = sp.f_price_id
left join t_detailprice dp on sp.id=dp.f_stairprice_id
left join t_stairprice sp1 on u1.f_stairprice_id = sp1.id
left join t_detailprice dp1 on sp1.id=dp1.f_stairprice_id
LEFT JOIN t_userinfo u4 ON u3.f_userinfo_id = u4.f_userinfo_id
left join (select id f_meter_book_id,f_book_slice_area,f_book_name f_meter_book from t_meter_book) met
    on u2.f_meter_book_num = met.f_meter_book_id
left join (select f_handplan_id,f_old_price,f_userinfo_id,f_change_date,f_changetime_type,f_operate_date from t_surplus_detail where f_state='有效') s
on u1.f_handplan_id = s.f_handplan_id and u1.f_userinfo_id=s.f_userinfo_id
left join t_chargeprice p on p.f_hand_id=u1.f_handplan_id
WHERE
	{condition} and sp.f_price_type='固定气价' AND u1.pregas > 0)
UNION ALL
(SELECT
    u2.f_filialeid,
	u4.f_userinfo_id,
	u4.f_userinfo_code,
	u4.f_user_name,
	u4.f_user_phone,
	u3.f_address,
	u2.f_user_type,
	u2.f_gasproperties,
	u2.f_total_gas,
	u2.f_user_id,
	u2.f_userfiles_id,
	u2.f_meter_base,
	u1.f_source,
	u1.f_meter_type,
	u1.f_stairprice_id,
	u1.f_handplan_id,
	u1.f_meter_brand,
	u1.f_meter_style,
	u1.f_last_hand_date f_last_input_date,
    u1.f_hand_date f_input_date,
	case when datediff(DD,u1.f_last_hand_date,u1.f_hand_date) is null then 1 else datediff(DD,u1.f_last_hand_date,u1.f_hand_date) end f_dd,
	u2.f_price_id,
	u2.f_meternumber,
	u1.pregas as f_pregas,
	sp.f_price_name,
	dp.f_price,
	isnull(f_old_price,0) f_old_price,
	isnull(u1.f_new_price,0) f_new_price,
	u1.f_change_price,
	u1.f_surplus_fee,
	u1.f_last_tablebase,
	u1.f_tablebase,
    met.f_book_slice_area,
    s.f_change_date f_change_date,
    s.f_changetime_type,
    s.f_operate_date,
    u1.f_inputtor,
    u2.f_meter_book_num
 FROM
	(
		SELECT
		  id as f_handplan_id,
			f_userfiles_id,
			f_userinfo_id,
			f_meter_brand,
			case when f_last_hand_date is null
						then
							(select max(f_hand_date) from t_cardhand where f_userfiles_id = t_cardhand.f_userfiles_id and id<t_cardhand.id AND f_meter_state = '已抄表')
						else f_last_hand_date end f_last_hand_date,
			f_hand_date,
			f_meter_style,
			'' f_stairprice_id,
			f_meter_classify f_meter_type,
			f_real_amount as pregas,
			'卡表抄表' f_source,
			isnull(f_new_price,0) f_new_price,
			f_change_price,
			f_surplus_fee,
			f_last_tablebase,
			f_tablebase,
          f_inputtor
		FROM
			t_cardhand
		WHERE
			f_hand_date BETWEEN '{startDate} 00:00:00'
		AND '{endDate} 23:59:59'
		AND f_meter_state = '已抄表'
	) u1
LEFT JOIN t_userfiles u2 ON u1.f_userfiles_id = u2.f_userfiles_id
LEFT JOIN t_user_address u3 ON u2.f_useraddress_id = u3.id
LEFT JOIN (
	SELECT
		*
	FROM
		t_stairprice
	where f_state = '有效'
	and f_perform_date <= getdate()
	and f_end_date >= getdate()
) sp ON u2.f_price_id = sp.f_price_id
left join t_detailprice dp on sp.id=dp.f_stairprice_id
LEFT JOIN t_userinfo u4 ON u3.f_userinfo_id = u4.f_userinfo_id
left join (select f_handplan_id,f_old_price,f_userinfo_id,f_change_date,f_changetime_type,f_operate_date from t_surplus_detail where f_state='有效') s
on u1.f_handplan_id = s.f_handplan_id and u1.f_userinfo_id=s.f_userinfo_id
left join (select id f_meter_book_id,f_book_slice_area from t_meter_book) met
    on u2.f_meter_book_num = met.f_meter_book_id
WHERE
	{condition}
	and sp.f_price_type='固定气价'
AND u1.pregas > 0)
) a
where f_input_date >= '{f_change_date} 00:00:00' --and f_last_input_date <='{f_change_date} 00:00:00'
ORDER BY
	f_handplan_id asc
