select isnull(f_residential_area, '>未存<')                              f_residential_area,
       isnull(count(uf_userinfo_id),0)                    f_user_number,--应抄户数
       isnull(COUNT(f_no_hand), 0)                              f_no_hand,--未抄户数
       isnull(count(f_out_hand), 0)                             f_out_hand,--已抄无用量
       isnull(count(f_yc_hand), 0)                              f_hand_num,--实抄户数
       cast(Convert(decimal (18, 2), case
                                         when count(uf_userinfo_id) = 0 then 0
                                         else count(f_yc_hand) /
                                              cast(count(uf_userinfo_id) as float) *
                                              100 end) as varchar) + '%' f_hand_lv,--抄表率
       isnull(sum(f_oughtamount), 0)                                     f_oughtamount,--期间抄表气量
       isnull(sum(f_oughtfee), 0)                                        f_oughtfee,--期间抄表金额
       isnull(sum(f_debt_money), 0)                                      f_debt_money, --期间实收气费金额
       isnull(count(f_sell_hand), 0)                            f_sell_hand,--已收户数
       cast(Convert(decimal (18, 2), case
                                         when count(f_yc_hand) = 0 then 0
                                         else count(f_sell_hand) / cast(count(f_yc_hand) as float) *
                                              100 end) as varchar) + '%' f_sell_lv--收费率
from (select h.f_userinfo_id uf_userinfo_id,
             case
                 when h.f_meter_state = '未抄表'
                     then h.f_userinfo_id end f_no_hand,
             case
                 when h.f_meter_state = '已抄表'
                     then h.f_userinfo_id end f_yc_hand,
             case
                 when h.f_input_date <= '{endDate}' and h.f_meter_state = '已抄表' and
                      h.f_oughtamount = 0
                     then h.f_userinfo_id end f_out_hand,
             case
                 when h.f_whether_pay = '是' and h.f_meter_state = '已抄表' and
                      h.f_input_date <= '{endDate}'
                     then h.f_userinfo_id end f_sell_hand,
             mb.f_inputtor,
             h.f_hand_date,
             h.f_input_person,
             mb.f_book_name,
             uf.f_user_type,
             uf.f_gasproperties,
             h.f_meter_classify,
             h.f_whether_pay,
             case
                 when h.f_input_date <= '{endDate}' then h.f_oughtamount
                 else 0 end                   f_oughtamount,
             case
                 when h.f_input_date <= '{endDate}' then h.f_oughtfee
                 else 0 end                   f_oughtfee,
             case
                 when h.f_input_date <= '{endDate}' then sh.f_charge_money
                 else 0 end                   f_charge_money,
             case
                 when h.f_input_date <= '{endDate}' then sh.f_debt_money
                 else 0 end                   f_debt_money,
             ua.f_slice_area as               f_zones,
             ua.f_residential_area,
             uf.f_orgid,
             uf.f_depid,
             uf.f_operatorid,
             mb.f_book_slice_area,
             uf.f_meter_book_num
      from t_handplan h
          left join t_userfiles uf
      on h.f_userfiles_id = uf.f_userfiles_id
          left join t_meter_book mb on uf.f_meter_book_num = mb.id
          left join t_user_address ua on uf.f_useraddress_id = ua.id
          left join (select f_hand_id,
          sum (f_charge_money) f_charge_money,
          sum (f_debt_money) f_debt_money
          from t_sellinghand
          where f_state != '无效'
          group by f_hand_id) sh on h.id = sh.f_hand_id
      where h.f_hand_date >= '{startDate}'
        and h.f_hand_date <= '{endDate}'
        and h.f_meter_classify = '机表'
        and h.f_hand_state = '有效'
--       union all
--       select h.f_userinfo_id uf_userinfo_id,
--              null f_no_hand,
--              case when f_hand_state != '作废' then h.f_userinfo_id end f_yc_hand,
--              case when f_hand_state != '作废' and h.f_oughtamount = 0 then h.f_userinfo_id end f_out_hand,
--               case when f_hand_state != '作废' and h.f_whether_pay = '是' then h.f_userinfo_id end f_sell_hand,
--               mb.f_inputtor, h.f_hand_date, h.f_input_person, mb.f_book_name, uf.f_user_type, uf.f_gasproperties,
--                h.f_meter_classify, h.f_whether_pay,
--                case when f_hand_state != '作废' then h.f_oughtamount else 0 end f_oughtamount,
--                case when f_hand_state != '作废' then h.f_oughtfee else 0 end f_oughtfee,
--                case when f_hand_state != '作废' then sh.f_charge_money else 0 end f_charge_money,
--                case when f_hand_state != '作废' then sh.f_debt_money else 0 end f_debt_money,
--                ua.f_slice_area as f_zones, ua.f_residential_area, uf.f_orgid, uf.f_depid,
--                uf.f_operatorid, mb.f_book_slice_area, uf.f_meter_book_num
--       from t_handplan h
--           left join t_userfiles uf
--       on h.f_userfiles_id = uf.f_userfiles_id
--           left join t_meter_book mb on uf.f_meter_book_num = mb.id
--           left join t_user_address ua on uf.f_useraddress_id = ua.id
--           left join (select f_hand_id,
--           sum (f_charge_money) f_charge_money,
--           sum (f_debt_money) f_debt_money
--           from t_sellinghand
--           where f_state != '无效'
--           group by f_hand_id) sh on h.id = sh.f_hand_id
--       where h.f_hand_date
--           < '{startDate}'
--         and h.f_input_date >= '{startDate}'
--         and h.f_input_date <= '{endDate}'
--         and h.f_meter_classify = '机表'
--         and h.f_hand_state = '有效'
--       union all
--       select uf.f_userinfo_id uf_userinfo_id, 0 f_no_hand, 0 f_yc_hand, 0 f_out_hand, 0 f_sell_hand, mb.f_inputtor, mb.f_hand_begin_date, mb.f_book_name, uf.f_user_type, '' f_input_person, uf.f_gasproperties, uf.f_meter_classify, '否' f_whether_pay, 0 f_oughtamount, 0 f_oughtfee, 0 f_charge_money, 0 f_debt_money, ua.f_slice_area as f_zones, ua.f_residential_area, uf.f_orgid, uf.f_depid, uf.f_operatorid, mb.f_book_slice_area, uf.f_meter_book_num
--       from t_userfiles uf
--           left join t_meter_book mb
--       on uf.f_meter_book_num = mb.id
--           left join t_user_address ua on uf.f_useraddress_id = ua.id
--       where mb.f_hand_begin_date >= getDate()
--         and mb.f_hand_begin_date <= '{endDate}'
--         and uf.f_meter_classify = '机表'
    ) s
where { condition }
group by f_residential_area
