/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public class Invoice {
    public static BigDecimal Scale(String num, int scale) {
        return new BigDecimal(num).setScale(scale, RoundingMode.HALF_UP);
    }

    public static String updateJSon(String json, JSONObject josnobj) {
        JSONObject jsonstr = new JSONObject(json);
        for (String str : josnobj.keySet()) {
            jsonstr.put(str, (Object)josnobj.getString(str));
        }
        return jsonstr.toString();
    }

    public static JSONObject removeKey(String key, JSONObject jsonObject) {
        jsonObject.remove(key);
        return jsonObject;
    }

    public static String arrToConditionString(String[] strings) {
        return ("(" + String.join((CharSequence)",", strings) + ")").replace("\"", "'");
    }

    public static String arrToConditionString(int[] arr) {
        CharSequence[] strAry = (String[])Arrays.stream(arr).mapToObj(String::valueOf).toArray(String[]::new);
        return ("(" + String.join((CharSequence)",", strAry) + ")").replace("\"", "'");
    }

    public static String arrToConditionString(JSONArray jsonArray) {
        return ("(" + jsonArray.join(",") + ")").replace("\"", "'");
    }

    public static String arrToConditionString(String id) {
        return "('" + id + "')".replace("\"", "'");
    }

    public static boolean IsArray(Object obj) {
        return obj instanceof JSONArray;
    }

    public static String getSerial(String f_operatorid) {
        Random random = new Random();
        LocalDateTime now = LocalDateTime.now();
        String SIGN = "QAZWSXEDCRFVTGBYHNUJMIKOLP";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            sb.append(SIGN.charAt(random.nextInt(SIGN.toCharArray().length)));
        }
        return sb + now.format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + f_operatorid;
    }

    public static String getSerial(String encrypt, String length) {
        Random random = new Random();
        LocalDateTime now = LocalDateTime.now();
        String SIGN = "QAZWSXEDCRFVTGBYHNUJMIKOLP";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2; ++i) {
            sb.append(SIGN.charAt(random.nextInt(SIGN.toCharArray().length)));
        }
        return (sb + now.format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + encrypt).substring(0, Integer.parseInt(length));
    }

    public static String fillZero(String str, int length) {
        StringBuffer buffer = new StringBuffer(str);
        if (buffer.length() >= length) {
            return buffer.toString();
        }
        while (buffer.length() < length) {
            buffer.append("0");
        }
        return buffer.toString();
    }

    public static String roundByScale(String v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        double str = Double.parseDouble(v);
        if (scale == 0) {
            return new DecimalFormat("0").format(str);
        }
        String formatStr = "0.";
        for (int i = 0; i < scale; ++i) {
            formatStr = formatStr + "0";
        }
        return new DecimalFormat(formatStr).format(str);
    }

    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        int i;
        int i2;
        int length = chargeInfo.length();
        BigDecimal sumamont = chargeInfo.getJSONObject(length - 1).getBigDecimal("sumamount");
        BigDecimal sumamont1 = chargeInfo.getJSONObject(length - 1).getBigDecimal("sumamount");
        BigDecimal[] stairPrice = new BigDecimal[length - 1];
        BigDecimal[] stairAmount = new BigDecimal[length - 2];
        BigDecimal[] stairFee = new BigDecimal[length - 1];
        BigDecimal[] stairNum = new BigDecimal[length - 1];
        BigDecimal[] stairSurplus = new BigDecimal[length - 2];
        JSONObject ret = new JSONObject();
        BigDecimal chargenum = new BigDecimal(0);
        BigDecimal oughtamount = new BigDecimal(0);
        for (i2 = 0; i2 < length - 1; ++i2) {
            stairPrice[i2] = new BigDecimal(0);
            stairFee[i2] = new BigDecimal(0);
            stairNum[i2] = new BigDecimal(0);
        }
        for (i2 = 0; i2 < length - 2; ++i2) {
            stairAmount[i2] = new BigDecimal(0);
            stairSurplus[i2] = new BigDecimal(0);
        }
        int start = 0;
        boolean end = false;
        for (i = 0; i < length - 2; ++i) {
            stairPrice[i] = chargeInfo.getJSONObject(i).getBigDecimal("price");
            stairAmount[i] = chargeInfo.getJSONObject(i).getBigDecimal("amount");
            if (sumamont.compareTo(stairAmount[i]) < 0) continue;
            start = i + 1;
        }
        stairPrice[i] = chargeInfo.getJSONObject(i).getBigDecimal("price");
        for (i = start; i < stairAmount.length; ++i) {
            if (stairAmount[i].subtract(sumamont).multiply(stairPrice[i]).compareTo(fee) >= 0) {
                int j;
                stairNum[i] = fee.divide(stairPrice[i], 10, 4);
                stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(4, 4);
                for (j = 0; j < i; ++j) {
                    stairSurplus[j] = BigDecimal.ZERO;
                    ret.put("f_stair" + (j + 1) + "surplus", (Object)stairSurplus[j]);
                }
                stairSurplus[i] = stairAmount[i].subtract(stairNum[i]).subtract(sumamont);
                ret.put("f_stair" + (i + 1) + "surplus", (Object)stairSurplus[i]);
                for (j = i + 1; j < stairAmount.length; ++j) {
                    stairSurplus[j] = stairAmount[j].subtract(stairAmount[j - 1]);
                    ret.put("f_stair" + (j + 1) + "surplus", (Object)stairSurplus[j]);
                }
                break;
            }
            stairNum[i] = stairAmount[i].subtract(sumamont);
            stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(4, 4);
            fee = fee.subtract(stairFee[i]);
            sumamont = stairAmount[i];
        }
        stairNum[i] = fee.divide(stairPrice[i], 10, 4);
        stairFee[i] = fee;
        JSONArray array = new JSONArray();
        for (i = 0; i < length - 1; ++i) {
            chargenum = chargenum.add(stairFee[i]);
            oughtamount = oughtamount.add(stairNum[i]);
            ret.put("f_stair" + (i + 1) + "fee", (Object)stairFee[i]);
            ret.put("f_stair" + (i + 1) + "amount", (Object)stairNum[i]);
            ret.put("f_stair" + (i + 1) + "price", (Object)stairPrice[i]);
            JSONObject json = new JSONObject();
            json.put("f_price", (Object)stairPrice[i]);
            json.put("f_gas", (Object)stairNum[i]);
            json.put("f_money", (Object)stairFee[i]);
            array.put((Object)json);
        }
        for (i = 0; i < stairAmount.length; ++i) {
            ret.put("f_stair" + (i + 1) + "ceiling", (Object)stairAmount[i]);
        }
        try {
            ret.get("f_stair1surplus");
        }
        catch (Exception e) {
            boolean json = false;
        }
        for (int j = 0; j < stairSurplus.length; ++j) {
            ret.put("f_stair" + (j + 1) + "surplus", (Object)stairSurplus[j]);
        }
        double chargeNumValue = this.formatNumber(chargenum);
        ret.put("chargenum", chargeNumValue);
        ret.put("sumamount", this.formatNumber(sumamont1));
        ret.put("gas", this.formatNumber(oughtamount));
        ret.put("chargeprice", (Object)array);
        return ret;
    }

    public double formatNumber(BigDecimal bigDecimal) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(8);
        String scoreStr = nf.format(bigDecimal.doubleValue());
        return Double.parseDouble(scoreStr);
    }

    public static String converPrice(String price) {
        if (Objects.equals(price, "\u9636\u68af\u4e00") || Objects.equals(price, "\u7b2c\u4e00\u6863") || Objects.equals(price, "\u9636\u68af1")) {
            return "\u9636\u68af\u6c14\u4ef7\u4e00";
        }
        if (Objects.equals(price, "\u9636\u68af\u4e8c") || Objects.equals(price, "\u7b2c\u4e8c\u6863") || Objects.equals(price, "\u9636\u68af2")) {
            return "\u9636\u68af\u6c14\u4ef7\u4e8c";
        }
        if (Objects.equals(price, "\u56fa\u5b9a\u6c14\u4ef7")) {
            return "\u56fa\u5b9a\u6c14\u4ef7";
        }
        if (Objects.equals(price, "\u6ede\u7eb3\u91d1")) {
            return "\u6ede\u7eb3\u91d1";
        }
        return "\u9636\u68af\u6c14\u4ef7\u4e09";
    }

    public JSONArray checkStair(JSONArray jsonArray) {
        JSONObject groupObj = new JSONObject();
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (groupObj.has(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString())) {
                BigDecimal gas = groupObj.getJSONObject(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString()).getBigDecimal("f_gas");
                BigDecimal money2 = groupObj.getJSONObject(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString()).getBigDecimal("f_money");
                gas = gas.add(jsonArray.getJSONObject(i).getBigDecimal("f_gas"));
                money2 = money2.add(jsonArray.getJSONObject(i).getBigDecimal("f_money"));
                groupObj.getJSONObject(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString()).put("f_gas", (Object)gas);
                groupObj.getJSONObject(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString()).put("f_money", (Object)money2);
                continue;
            }
            groupObj.put(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString(), (Object)jsonArray.getJSONObject(i));
        }
        JSONArray result = new JSONArray();
        for (String str : groupObj.keySet()) {
            if (groupObj.getJSONObject(str).getBigDecimal("f_money").compareTo(BigDecimal.ZERO) == 0 && groupObj.getJSONObject(str).getBigDecimal("f_gas").compareTo(BigDecimal.ZERO) == 0) continue;
            groupObj.getJSONObject(str).put("f_gas", (Object)groupObj.getJSONObject(str).getBigDecimal("f_gas").setScale(8, RoundingMode.HALF_UP));
            result.put((Object)groupObj.getJSONObject(str));
        }
        return result;
    }

    public static JSONObject getConfigValue(JSONObject config, String key) {
        String keysItem;
        Iterator var2 = config.keySet().iterator();
        do {
            if (var2.hasNext()) continue;
            return new JSONObject("{nosuch:true}");
        } while (!(keysItem = (String)var2.next()).contains(key));
        return config.getJSONObject(keysItem);
    }
}

