/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import cn.hutool.core.util.NumberUtil;
import com.af.plugins.CommonTools;
import com.af.plugins.RestTools;
import com.af.plugins.timeoutReturn.TimeCache;
import com.aote.rs.LogicService;
import com.aote.rs.SqlService;
import com.aote.sql.SqlMapper;
import com.aote.util.Util;
import file.ReadFile;
import java.math.BigDecimal;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="business")
@Component
public class BatchBusinessBase {
    private static final Logger LOGGER = Logger.getLogger(BatchBusinessBase.class);
    @Autowired
    private SqlService sqlService;
    @Autowired
    private LogicService logicService;
    @Autowired
    private TimeCache timeCache;
    private static final Integer processors = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService executorService = Executors.newFixedThreadPool(4);

    public static void main(String[] args) {
        String str = "12";
        JSONObject param = new JSONObject(str);
        System.out.println(param);
        JSONObject jsonObject = param.getJSONObject("data");
        System.out.println("\u4f20\u8fc7\u6765\u7684data\u6570\u636e:" + jsonObject);
        String inputcode = param.getString("inputcode");
        System.out.println("inputcode:" + inputcode);
        JSONObject address = jsonObject.getJSONObject("address");
        System.out.println("\u771f\u6b63\u7684address:" + address);
        JSONObject userinfo = jsonObject.getJSONObject("userinfo");
        System.out.println("\u771f\u6b63\u7684userinfo:" + userinfo);
    }

    @POST
    @Path(value="batchRun/{logicName}")
    public Object batchRunByResult(@PathParam(value="logicName") String logicName, String values, @Context HttpServletRequest request) {
        LOGGER.debug((Object)("\u4f20\u6765\u7684\u6570\u636e:" + values));
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject batchParam = data.getJSONObject("batchParam");
        LOGGER.info((Object)batchParam);
        JSONObject jobParam = data.getJSONObject("jobParam");
        Object result = this.doBusinessBySqlResult(logicName, values, jobParam, batchParam, request);
        return result;
    }

    @POST
    @Path(value="batchRun/quickTimerExecute")
    public Object quickTimerExecute() {
        String updateResult = "0";
        try {
            LOGGER.debug((Object)"BatchJobTimer\u5b9a\u65f6\u6267\u884c\u6279\u91cf\u4efb\u52a1\u7acb\u5373\u6267\u884c");
            String executeData = this.logicService.xtSave("getExecuteParam", "{data:{}}");
            if (executeData != null) {
                JSONObject jsonObject = new JSONObject(executeData);
                int code = jsonObject.getInt("code");
                if (code < 2000) {
                    int jobId = jsonObject.getInt("jobId");
                    Object o = this.leisureExecute(jsonObject);
                    if (o != "0") {
                        updateResult = this.logicService.xtSave("getExecuteParam", "{data:{jobId:" + jobId + "}}");
                        LOGGER.debug((Object)("\u6267\u884c\u5b8c\u6bd5" + updateResult));
                    }
                    this.logicService.xtSave("testLogicJob", jsonObject.toString());
                }
            } else {
                LOGGER.debug((Object)("\u6ca1\u6709\u53ef\u6267\u884c\u7684\u4efb\u52a1\u6570\u636e" + updateResult));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return updateResult;
    }

    @POST
    @Path(value="batchRun/{logicName}/{sqlName}")
    public Object batchRunByName(@PathParam(value="logicName") String logicName, @PathParam(value="sqlName") String sqlName, String values, @Context HttpServletRequest request) {
        LOGGER.debug((Object)("\u4f20\u6765\u7684\u6570\u636e:" + values));
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject)data.get("jobParam");
        JSONObject sqlParam = data.getJSONObject("sqlParam");
        Object result = null;
        if (data.optBoolean("isNowRun", false)) {
            return this.doBusiness(logicName, params, jobParam, null, sqlName, String.valueOf(sqlParam), request);
        }
        result = this.doBusinessBySqlName(logicName, jobParam, sqlName, sqlParam, request);
        return result;
    }

    @POST
    @Path(value="batchRunNew/{logicName}/{batchName}")
    public Object batchRunByResultName(@PathParam(value="logicName") String logicName, @PathParam(value="batchName") String batchName, String values, @Context HttpServletRequest request) {
        LOGGER.debug((Object)("\u4f20\u6765\u7684\u6570\u636e:" + values));
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject)data.get("jobParam");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data", (Object)batchParam);
        Object result = this.doBusinessByLogicName(logicName, jobParam, batchName, params, request);
        return result;
    }

    @POST
    @Path(value="batchRunAudit/{logicName}/{batchName}")
    public Object batchRunByResultNameAudit(@PathParam(value="logicName") String logicName, @PathParam(value="batchName") String batchName, String values, @Context HttpServletRequest request) {
        LOGGER.debug((Object)("\u4f20\u6765\u7684\u6570\u636e:" + values));
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data", (Object)batchParam);
        Object result = this.doBusinessByLogicNameAudit(logicName, batchName, params);
        return result;
    }

    @POST
    @Path(value="batchRunExcel/{logicName}/{batchName}")
    public Object batchRunByExcelImport(@PathParam(value="logicName") String logicName, @PathParam(value="batchName") String batchName, String values, @Context HttpServletRequest request) {
        LOGGER.debug((Object)("\u4f20\u6765\u7684\u6570\u636e:" + values));
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject)data.get("jobParam");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data", (Object)batchParam);
        Util util = new Util();
        if (batchParam.getString("uuid") != null && !"".equals(batchParam.getString("uuid"))) {
            Object result = this.doBusinessByExcel(logicName, jobParam, batchName, params, request);
            return result;
        }
        util.error(new JSONObject("{status:801,msg:\"\u65e0\u6cd5\u83b7\u53d6uuid,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\"}"));
        return null;
    }

    @POST
    @Path(value="batchRunExcelDefault/{logicName}/{batchName}")
    public Object batchRunByExcelImportDefault(@PathParam(value="logicName") String logicName, @PathParam(value="batchName") String batchName, String values, @Context HttpServletRequest request) {
        LOGGER.debug((Object)("\u4f20\u6765\u7684\u6570\u636e:" + values));
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject)data.get("jobParam");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data", (Object)batchParam);
        Object result = this.doBusinessByExcelDefault(logicName, jobParam, batchName, params, request);
        return result;
    }

    @POST
    @Path(value="batchRunExcelProgress/{logicName}/{batchName}")
    public Object batchRunByExcelImportProgress(@PathParam(value="logicName") String logicName, @PathParam(value="batchName") String batchName, String values, @Context HttpServletRequest request) {
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject)data.get("jobParam");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data", (Object)batchParam);
        Object result = this.doBusinessByExcelProgress(logicName, jobParam, batchName, params, request);
        return result;
    }

    private Object doBusinessBySqlResult(String logicName, String values, JSONObject jobParam, JSONObject batchParam, HttpServletRequest request) {
        JSONArray sqlResult = batchParam.getJSONArray("con");
        return this.doBusiness(logicName, batchParam, jobParam, sqlResult, null, null, request);
    }

    private Object doBusinessBySqlName(String logicName, JSONObject jobParam, String sqlName, JSONObject sqlParams, HttpServletRequest request) {
        return this.doBusiness(logicName, jobParam, null, sqlName, sqlParams, request);
    }

    private Object doBusinessByLogicName(String logicName, JSONObject jobParam, String batchName, JSONObject batchParams, HttpServletRequest request) {
        String result = "{\"data\":{}}";
        try {
            result = this.logicService.xtSave(batchName, batchParams.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        JSONObject batchParam = new JSONObject(result);
        JSONArray logicResult = batchParam.getJSONArray("con");
        return this.doBusiness(logicName, batchParam, jobParam, logicResult, null, null, request);
    }

    private Object doBusinessByLogicNameAudit(String logicName, String batchName, JSONObject batchParams) {
        String result = "{\"data\":{}}";
        try {
            result = this.logicService.xtSave(batchName, batchParams.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        JSONObject batchParam = new JSONObject(result);
        return this.doBusinessAudit(logicName, batchParam);
    }

    private Object doBusinessSingleProgress(String logicName, JSONObject batchParam, JSONObject jobParam, JSONArray sqlResult, String sqlName, String sqlParams, HttpServletRequest request) {
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        String operator = jobParam.getString("operator");
        String jobType = jobParam.getString("jobType");
        jobData.put("operator", (Object)operator);
        jobData.put("jobType", (Object)(jobType + "\u3010\u7acb\u5373\u6267\u884c\u3011"));
        JSONObject data = new JSONObject();
        LOGGER.info((Object)("======\u5f00\u59cb\u6267\u884c\u6279\u91cf[" + logicName + "]\u4e1a\u52a1\u6d41\u7a0b======"));
        JSONArray resultArray = sqlName != null ? this.getSqlResult(sqlName, sqlParams) : sqlResult;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id", 0);
            jobData.put("job_name", (Object)(operator + jobType + resultArray.length()));
            jobData.put("count", resultArray.length());
            jobData.put("operator_id", jobParam.get("f_operatorid"));
            jobData.put("content", (Object)batchParam);
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress", 1);
            try {
                endData.put("data", (Object)jobData);
                String result = this.logicService.xtSave("addJobBuniness", endData.toString());
                JSONObject results = new JSONObject(result);
                int id = results.getInt("jobId");
                jobData.put("id", id);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            for (Object o : resultArray) {
                try {
                    System.out.println(o);
                    batchParam.put("con", o);
                    batchParam.put("logicName", (Object)logicName);
                    this.runLogic("batchjobtemplate", batchParam, request, countData);
                    int progress = ai.getAndIncrement();
                    LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u4e2d\uff1a\u603b\u6570\uff1a" + countData.getInt("total") + ", \u5f53\u524d\uff1a" + progress + "======="));
                    jobData.put("progress", progress);
                    if (countData.getInt("total") != progress && countData.getInt("total") != 3 * progress && 2 * countData.getInt("total") != 3 * progress) continue;
                    endData.put("data", (Object)jobData);
                    String result = this.logicService.xtSave("addJobBuniness", endData.toString());
                    JSONObject inresults = new JSONObject(result);
                    int getId = inresults.getInt("jobId");
                    if (getId != 0) {
                        jobData.put("id", getId);
                    }
                    LOGGER.info((Object)("\u66f4\u65b0jobData:" + jobData.toString()));
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u7ed3\u675f\uff0c\u9519\u8bef\u6570\uff1a" + countData.getInt("errorCount") + "======="));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("totalsum", countData.getInt("total"));
            jsonObject.put("errorsum", countData.getInt("errorCount"));
            jsonObject.put("successnum", countData.getInt("total") - countData.getInt("errorCount"));
            return jsonObject.toString();
        }
        LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        return "0";
    }

    private Object doBusinessByExcel(String logicName, JSONObject jobParam, String batchName, JSONObject batchParams, HttpServletRequest request) {
        String result = "{\"data\":{}}";
        try {
            result = this.logicService.xtSave(batchName, batchParams.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        JSONObject batchParam = new JSONObject(result);
        JSONArray logicResult = batchParam.getJSONArray("con");
        return this.doBusinessExcel(logicName, batchParam, jobParam, logicResult, null, batchParams.getJSONObject("data"), request);
    }

    private Object doBusinessByExcelDefault(String logicName, JSONObject jobParam, String batchName, JSONObject batchParams, HttpServletRequest request) {
        String result = "{\"data\":{}}";
        try {
            result = this.logicService.xtSave(batchName, batchParams.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        JSONObject batchParam = new JSONObject(result);
        JSONArray logicResult = batchParam.getJSONArray("con");
        int totalcount = batchParam.getInt("totalsum");
        return this.doBusinessExcelDefault(logicName, batchParam, jobParam, logicResult, totalcount, null, batchParams.getJSONObject("data"), request);
    }

    private Object doBusinessByExcelProgress(String logicName, JSONObject jobParam, String batchName, JSONObject batchParams, HttpServletRequest request) {
        String result = "{\"data\":{}}";
        try {
            result = this.logicService.xtSave(batchName, batchParams.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        JSONObject batchParam = new JSONObject(result);
        JSONArray logicResult = batchParam.getJSONArray("con");
        int totalcount = batchParam.getInt("totalsum");
        return this.doBusinessExcelProgress(logicName, batchParam, jobParam, logicResult, totalcount, null, batchParams.getJSONObject("data"), request);
    }

    private Object doBusiness(String logicName, JSONObject jobParam, JSONArray sqlResult, String sqlName, JSONObject sqlParams, HttpServletRequest request) {
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        String operator = jobParam.getString("operator");
        String jobType = jobParam.getString("jobType");
        jobData.put("operator", (Object)operator);
        jobData.put("jobType", (Object)(jobType + "\u3010\u95f2\u65f6\u6267\u884c,\u5c06\u5728\u591c\u95f40-5\u70b9\u6267\u884c\u3011"));
        JSONArray resultArray = sqlName != null ? this.getSqlResult(sqlName, sqlParams.toString()) : sqlResult;
        String auditPerson = sqlParams.getString("f_audit_person");
        JSONArray paramArray = new JSONArray();
        if (resultArray != null && resultArray.length() > 0) {
            for (int i = 0; i < resultArray.length(); ++i) {
                JSONObject jsonObject = (JSONObject)resultArray.get(i);
                JSONObject newParam = new JSONObject();
                newParam.put("f_audit_person", (Object)auditPerson);
                newParam.put("f_hand_id", jsonObject.get("id"));
                newParam.put("f_tablebase", jsonObject.get("f_tablebase"));
                newParam.put("f_meter_classify", jsonObject.get("f_meter_classify"));
                newParam.put("f_meter_brand", jsonObject.get("f_meter_brand"));
                paramArray.put((Object)newParam);
            }
        }
        int jobId = 0;
        String result = "";
        if (paramArray != null && paramArray.length() > 0) {
            jobData.put("job_name", (Object)(operator + jobType + resultArray.length()));
            jobData.put("count", resultArray.length());
            jobData.put("operator_id", jobParam.get("f_operatorid"));
            jobData.put("progress", 0);
            jobData.put("id", 0);
            jobData.put("content", (Object)paramArray);
            try {
                endData.put("data", (Object)jobData);
                result = this.logicService.xtSave("addJobBuniness", endData.toString());
                JSONObject results = new JSONObject(result);
                jobId = results.getInt("jobId");
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            try {
                JSONObject batchParam = new JSONObject();
                batchParam.put("con", (Object)paramArray);
                batchParam.put("f_job_id", jobId);
                batchParam.put("logicName", (Object)logicName);
                endData.put("data", (Object)batchParam);
                result = this.logicService.xtSave("batchJobTimer", endData.toString());
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            return result;
        }
        LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        return "0";
    }

    private Object doBusiness(String logicName, JSONObject batchParam, JSONObject jobParam, JSONArray sqlResult, String sqlName, String sqlParams, HttpServletRequest request) {
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        String operator = jobParam.getString("operator");
        String jobType = jobParam.getString("jobType");
        jobData.put("operator", (Object)operator);
        jobData.put("jobType", (Object)(jobType + "\u3010\u7acb\u5373\u6267\u884c\u3011"));
        JSONObject data = new JSONObject();
        LOGGER.info((Object)("======\u5f00\u59cb\u6267\u884c\u6279\u91cf[" + logicName + "]\u4e1a\u52a1\u6d41\u7a0b======"));
        JSONArray resultArray = sqlName != null ? this.getSqlResult(sqlName, sqlParams) : sqlResult;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id", 0);
            jobData.put("job_name", (Object)(operator + jobType + resultArray.length()));
            jobData.put("count", resultArray.length());
            jobData.put("operator_id", jobParam.get("f_operatorid"));
            jobData.put("content", (Object)batchParam);
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress", 1);
            try {
                endData.put("data", (Object)jobData);
                String result = this.logicService.xtSave("addJobBuniness", endData.toString());
                JSONObject results = new JSONObject(result);
                int id = results.getInt("jobId");
                jobData.put("id", id);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            resultArray.forEach(item -> executorService.execute(() -> {
                try {
                    JSONObject exeParam = new JSONObject();
                    exeParam.put("con", item);
                    exeParam.put("logicName", (Object)logicName);
                    this.runLogic("batchjobtemplate", exeParam, request, countData);
                    int progress = ai.getAndIncrement();
                    LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u4e2d\uff1a\u603b\u6570\uff1a" + countData.getInt("total") + ", \u5f53\u524d\uff1a" + progress + "======="));
                    jobData.put("progress", progress);
                    if (progress == 1 || progress == countData.getInt("total") || progress % (countData.getInt("total") / 100) == 0) {
                        endData.put("data", (Object)jobData);
                        String result = this.logicService.xtSave("addJobBuniness", endData.toString());
                        JSONObject inresults = new JSONObject(result);
                        int getId = inresults.getInt("jobId");
                        if (getId != 0) {
                            jobData.put("id", getId);
                        }
                        LOGGER.info((Object)("\u66f4\u65b0jobData:" + jobData.toString()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }));
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u7ed3\u675f\uff0c\u9519\u8bef\u6570\uff1a" + countData.getInt("errorCount") + "======="));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("totalsum", countData.getInt("total"));
            jsonObject.put("errorsum", countData.getInt("errorCount"));
            jsonObject.put("successnum", countData.getInt("total") - countData.getInt("errorCount"));
            return jsonObject.toString();
        }
        LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        return "0";
    }

    private Object doBusinessAudit(String logicName, JSONObject batchParam) {
        int size;
        LOGGER.info((Object)("======\u5f00\u59cb\u6267\u884c\u6279\u91cf[" + logicName + "]\u4e1a\u52a1\u6d41\u7a0b======"));
        int total = batchParam.getInt("total");
        String cond = batchParam.getString("condition");
        String f_mark = batchParam.getString("f_mark");
        String tableName = batchParam.getString("tableName");
        batchParam.remove("f_mark");
        int n = size = total % 1000 > 0 ? total / 1000 + 1 : total / 1000;
        if (total > 0) {
            JSONObject countData = new JSONObject();
            countData.put("index", 1);
            countData.put("errorCount", 0);
            countData.put("total", total);
            AtomicInteger ai = new AtomicInteger(1000);
            JSONArray resultArray = new JSONArray();
            for (int i = 0; i < size; ++i) {
                resultArray.put(ai.getAndAdd(1000));
            }
            batchParam.put("logicName", (Object)logicName);
            CountDownLatch latch = new CountDownLatch(size);
            resultArray.forEach(item -> executorService.execute(() -> {
                try {
                    JSONObject exeParam = new JSONObject();
                    exeParam.put("tableName", (Object)tableName);
                    exeParam.put("logicName", (Object)logicName);
                    exeParam.put("condition", (Object)cond);
                    exeParam.put("endNum", item);
                    this.runLogic("batchjobtemplate", exeParam, null, countData);
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
                finally {
                    latch.countDown();
                }
            }));
            try {
                latch.await();
                batchParam.put("f_mark", (Object)f_mark);
                String string = this.runLogic("batchjobtemplate", batchParam, null, countData);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("totalsum", countData.getInt("total"));
            jsonObject.put("errorsum", countData.getInt("errorCount"));
            jsonObject.put("successnum", countData.getInt("total") - countData.getInt("errorCount"));
            return jsonObject.toString();
        }
        LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        return "0";
    }

    private Object doBusinessExcelProgress(String logicName, JSONObject batchParam, JSONObject jobParam, JSONArray sqlResult, int totalCount, String sqlName, JSONObject batchParams, HttpServletRequest request) {
        JSONObject result = new JSONObject();
        result.put("totalsum", 0);
        result.put("successsum", 0);
        result.put("errorsum", 0);
        result.put("code", 200);
        result.put("msg", (Object)"\u5bfc\u5165\u5b8c\u6210");
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        String operator = jobParam.getString("operator");
        String jobType = jobParam.getString("jobType");
        jobData.put("operator", (Object)operator);
        jobData.put("jobType", (Object)(jobType + "\u3010\u7acb\u5373\u6267\u884c\u3011"));
        JSONObject data = new JSONObject();
        LOGGER.info((Object)("======\u5f00\u59cb\u6267\u884c\u6279\u91cf[" + logicName + "]\u4e1a\u52a1\u6d41\u7a0b======"));
        JSONArray resultArray = sqlName != null ? null : sqlResult;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id", 0);
            jobData.put("job_name", (Object)(operator + jobType + resultArray.length()));
            jobData.put("count", resultArray.length());
            jobData.put("operator_id", jobParam.get("f_operatorid"));
            jobData.put("content", (Object)logicName);
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress", 1);
            try {
                endData.put("data", (Object)jobData);
                String result1 = this.logicService.xtSave("addJobBuniness", endData.toString());
                JSONObject results = new JSONObject(result1);
                int id = results.getInt("jobId");
                jobData.put("id", id);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            CountDownLatch latch = new CountDownLatch(resultArray.length());
            resultArray.forEach(item -> executorService.execute(() -> {
                try {
                    JSONObject exeParam = new JSONObject();
                    exeParam.put("con", item);
                    exeParam.put("logicName", (Object)logicName);
                    this.runLogic("batchjobtemplate", exeParam, request, countData);
                    int progress = ai.getAndIncrement();
                    LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u4e2d\uff1a\u603b\u6570\uff1a" + countData.getInt("total") + ", \u5f53\u524d\uff1a" + progress + "======="));
                    jobData.put("progress", progress);
                    if (progress == 1 || progress == countData.getInt("total") || progress % (countData.getInt("total") / 100) == 0) {
                        endData.put("data", (Object)jobData);
                        String result1 = this.logicService.xtSave("addJobBuniness", endData.toString());
                        JSONObject inresults = new JSONObject(result1);
                        int getId = inresults.getInt("jobId");
                        if (getId != 0) {
                            jobData.put("id", getId);
                        }
                        LOGGER.info((Object)("\u66f4\u65b0jobData:" + jobData.toString()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
                finally {
                    latch.countDown();
                }
            }));
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)e);
            }
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u7ed3\u675f\uff0c\u9519\u8bef\u6570\uff1a" + countData.getInt("errorCount") + "======="));
            result.put("totalCount", totalCount);
            result.put("totalsum", countData.getInt("total"));
            result.put("errorsum", countData.getInt("errorCount"));
            result.put("successsum", countData.getInt("total") - countData.getInt("errorCount"));
            result.put("msg", (Object)"\u5bfc\u5165\u5b8c\u6210");
            return result.toString();
        }
        LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        return "0";
    }

    private Object doBusinessExcelDefault(String logicName, JSONObject batchParam, JSONObject jobParam, JSONArray sqlResult, int totalCount, String sqlName, JSONObject batchParams, HttpServletRequest request) {
        JSONObject result = new JSONObject();
        result.put("speed", 0);
        result.put("totalsum", 0);
        result.put("successsum", 0);
        result.put("errorsum", 0);
        result.put("code", 200);
        result.put("msg", (Object)"\u5bfc\u5165\u5b8c\u6210");
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        String operator = jobParam.getString("operator");
        String jobType = jobParam.getString("jobType");
        jobData.put("operator", (Object)operator);
        jobData.put("jobType", (Object)(jobType + "\u3010\u7acb\u5373\u6267\u884c\u3011"));
        JSONObject data = new JSONObject();
        LOGGER.info((Object)("======\u5f00\u59cb\u6267\u884c\u6279\u91cf[" + logicName + "]\u4e1a\u52a1\u6d41\u7a0b======"));
        JSONArray resultArray = sqlName != null ? null : sqlResult;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id", 0);
            jobData.put("job_name", (Object)(operator + jobType + resultArray.length()));
            jobData.put("count", resultArray.length());
            jobData.put("operator_id", jobParam.get("f_operatorid"));
            jobData.put("content", (Object)batchParam);
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress", 1);
            try {
                endData.put("data", (Object)jobData);
                LOGGER.info((Object)"*************2");
                String result1 = this.logicService.xtSave("addJobBuniness", endData.toString());
                JSONObject results = new JSONObject(result1);
                int id = results.getInt("jobId");
                jobData.put("id", id);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            for (Object o : resultArray) {
                try {
                    batchParam.put("con", o);
                    batchParam.put("logicName", (Object)logicName);
                    this.runLogic("batchjobtemplate", batchParam, request, countData);
                    int progress = ai.getAndIncrement();
                    BigDecimal aaa = NumberUtil.div((Number)progress, (Number)countData.getInt("total"), (int)10);
                    BigDecimal total = CommonTools.mul((Object)aaa, (Object)100, (int)0);
                    result.put("speed", (Object)total);
                    if (result.getBigDecimal("speed").compareTo(new BigDecimal(100)) == 0 || result.getBigDecimal("speed").compareTo(new BigDecimal(100)) > 0) {
                        result.put("speed", 99);
                    }
                    LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u4e2d\uff1a\u603b\u6570\uff1a" + countData.getInt("total") + ", \u5f53\u524d\uff1a" + progress + "======="));
                    jobData.put("progress", progress);
                    if (progress != 1 && progress != countData.getInt("total") && progress % countData.getInt("total") != 0) continue;
                    endData.put("data", (Object)jobData);
                    String result1 = this.logicService.xtSave("addJobBuniness", endData.toString());
                    JSONObject inresults = new JSONObject(result1);
                    int getId = inresults.getInt("jobId");
                    if (getId != 0) {
                        jobData.put("id", getId);
                    }
                    LOGGER.info((Object)("\u66f4\u65b0jobData:" + jobData));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error((Object)e);
                }
            }
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u7ed3\u675f\uff0c\u9519\u8bef\u6570\uff1a" + countData.getInt("errorCount") + "======="));
            result.put("speed", 100);
            result.put("totalCount", totalCount);
            result.put("totalsum", countData.getInt("total"));
            result.put("errorsum", countData.getInt("errorCount"));
            result.put("successsum", countData.getInt("total") - countData.getInt("errorCount"));
            result.put("msg", (Object)"\u5bfc\u5165\u5b8c\u6210");
            return result.toString();
        }
        LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        return "0";
    }

    private Object doBusinessExcel(String logicName, JSONObject batchParam, JSONObject jobParam, JSONArray sqlResult, String sqlName, JSONObject batchParams, HttpServletRequest request) {
        Util util = new Util();
        JSONObject result = new JSONObject();
        result.put("speed", 0);
        result.put("totalsum", 0);
        result.put("successsum", 0);
        result.put("errorsum", 0);
        result.put("code", 200);
        result.put("msg", (Object)"\u5bfc\u5165\u5b8c\u6210");
        try {
            this.timeCache.setCahce(batchParams.getString("uuid"), result);
        }
        catch (Exception e) {
            util.error(new JSONObject("{status:605,msg:\"\u5bfc\u5165\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0credis\u672a\u8fde\u63a5\uff01\"}"));
        }
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        String operator = jobParam.getString("operator");
        String jobType = jobParam.getString("jobType");
        jobData.put("operator", (Object)operator);
        jobData.put("jobType", (Object)(jobType + "\u3010\u7acb\u5373\u6267\u884c\u3011"));
        JSONObject data = new JSONObject();
        LOGGER.info((Object)("======\u5f00\u59cb\u6267\u884c\u6279\u91cf[" + logicName + "]\u4e1a\u52a1\u6d41\u7a0b======"));
        JSONArray resultArray = sqlName != null ? null : sqlResult;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id", 0);
            jobData.put("job_name", (Object)(operator + jobType + resultArray.length()));
            jobData.put("count", resultArray.length());
            jobData.put("operator_id", jobParam.get("f_operatorid"));
            jobData.put("content", (Object)batchParam);
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress", 1);
            try {
                endData.put("data", (Object)jobData);
                LOGGER.info((Object)"*************2");
                String result1 = this.logicService.xtSave("addJobBuniness", endData.toString());
                JSONObject results = new JSONObject(result1);
                int id = results.getInt("jobId");
                jobData.put("id", id);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            for (Object o : resultArray) {
                try {
                    System.out.println(o);
                    batchParam.put("con", o);
                    batchParam.put("logicName", (Object)logicName);
                    this.runLogic("batchjobtemplate", batchParam, request, countData);
                    int progress = ai.getAndIncrement();
                    BigDecimal total = CommonTools.mul((Object)CommonTools.div((Object)progress, (Object)countData.getInt("total")), (Object)100, (int)0);
                    result.put("speed", (Object)total);
                    if (result.getBigDecimal("speed").compareTo(new BigDecimal(100)) == 0 || result.getBigDecimal("speed").compareTo(new BigDecimal(100)) > 0) {
                        result.put("speed", 99);
                    }
                    this.timeCache.setCahce(batchParams.getString("uuid"), result);
                    LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u4e2d\uff1a\u603b\u6570\uff1a" + countData.getInt("total") + ", \u5f53\u524d\uff1a" + progress + "======="));
                    jobData.put("progress", progress);
                    if (countData.getInt("total") != progress && countData.getInt("total") != 3 * progress && 2 * countData.getInt("total") != 3 * progress) continue;
                    endData.put("data", (Object)jobData);
                    String result1 = this.logicService.xtSave("addJobBuniness", endData.toString());
                    JSONObject inresults = new JSONObject(result1);
                    int getId = inresults.getInt("jobId");
                    if (getId != 0) {
                        jobData.put("id", getId);
                    }
                    LOGGER.info((Object)("\u66f4\u65b0jobData:" + jobData.toString()));
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u7ed3\u675f\uff0c\u9519\u8bef\u6570\uff1a" + countData.getInt("errorCount") + "======="));
            result.put("speed", 100);
            result.put("totalsum", countData.getInt("total"));
            result.put("errorsum", countData.getInt("errorCount"));
            result.put("successsum", countData.getInt("total") - countData.getInt("errorCount"));
            result.put("msg", (Object)"\u5bfc\u5165\u5b8c\u6210");
            try {
                this.timeCache.setCahce(batchParams.getString("uuid"), result);
            }
            catch (Exception e) {
                util.error(new JSONObject("{status:605,msg:\"\u5bfc\u5165\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0credis\u672a\u8fde\u63a5\uff01\"}"));
            }
            return result.toString();
        }
        LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        return "0";
    }

    private JSONArray getSqlResult(String sqlName, String sqlData) {
        if (SqlMapper.getSql((String)sqlName) == null) {
            LOGGER.info((Object)("\u672a\u627e\u5230\u540d\u4e3a\u3010" + sqlName + "\u3011\u7684SQL\u6620\u5c04\u6587\u4ef6"));
            return null;
        }
        try {
            JSONObject params = new JSONObject();
            JSONObject conditionParam = new JSONObject(sqlData);
            params.put("data", (Object)conditionParam);
            LOGGER.info((Object)("sql\u7ec4\u88c5data:" + params.toString()));
            return new JSONArray(this.sqlService.txExecute(sqlName, 1, 9999999, params.toString()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private String runLogic(String logicName, JSONObject data, HttpServletRequest request, JSONObject countData) {
        ReadFile file = new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/auditConfig.json"));
        LOGGER.info((Object)("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\uff1a" + conf.toString()));
        LOGGER.info((Object)("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\uff1a" + (Boolean)conf.get("audit")));
        if (((Boolean)conf.get("audit")).booleanValue()) {
            LOGGER.info((Object)"\u5f53\u524d\u8d70\u7684\u662f\u8c03\u7528audit\u670d\u52a1");
            try {
                return RestTools.post((String)(conf.get("auditUri") + "/rs/logic/" + logicName), (String)data.toString());
            }
            catch (Exception e) {
                int errorCount = countData.getInt("errorCount") + 1;
                countData.put("errorCount", errorCount);
            }
        } else {
            try {
                return this.logicService.xtSave(logicName, data.toString());
            }
            catch (Exception e) {
                int errorCount = countData.getInt("errorCount") + 1;
                countData.put("errorCount", errorCount);
            }
        }
        LOGGER.debug((Object)"logic\u6267\u884c\u7ed3\u675f");
        return "0";
    }

    public void runLeiSureLogic(String logicName, JSONObject data, JSONObject countData) {
        ReadFile file = new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/auditConfig.json"));
        if (((Boolean)conf.get("audit")).booleanValue()) {
            try {
                RestTools.post((String)(conf.get("auditUri") + "/rs/logic/" + logicName), (String)data.toString());
            }
            catch (Exception e) {
                int errorCount = countData.getInt("errorCount") + 1;
                countData.put("errorCount", errorCount);
            }
        } else {
            try {
                this.logicService.xtSave(logicName, data.toString());
            }
            catch (Exception e) {
                int errorCount = countData.getInt("errorCount") + 1;
                countData.put("errorCount", errorCount);
            }
        }
    }

    public void meterDownBatchAudit(String logicName, JSONObject batchParam) {
        this.doBusinessAudit(logicName, batchParam);
    }

    public void meterDownBatch(JSONObject batchParam) {
        String logicName = batchParam.getString("logicName");
        JSONArray executeParam = batchParam.getJSONArray("executeParam");
        LOGGER.info((Object)("======\u5f00\u59cb\u6267\u884c\u6279\u91cf[" + logicName + "]\u4e1a\u52a1\u6d41\u7a0b======"));
        batchParam.remove("executeParam");
        JSONArray resultArray = executeParam;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            AtomicInteger ai = new AtomicInteger(1);
            resultArray.forEach(item -> executorService.execute(() -> {
                try {
                    JSONObject exeParam = new JSONObject();
                    exeParam.put("logicName", (Object)logicName);
                    exeParam.put("con", item);
                    this.runLeiSureLogic("batchjobtemplate", exeParam, countData);
                    LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u4e2d\uff1a\u603b\u6570\uff1a" + countData.getInt("total") + ", \u5f53\u524d\uff1a" + ai.getAndIncrement() + "======="));
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }));
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u7ed3\u675f\uff0c\u9519\u8bef\u6570\uff1a" + countData.getInt("errorCount") + "======="));
        } else {
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        }
    }

    public Object leisureExecute(JSONObject batchParam) {
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        new JSONObject();
        String logicName = batchParam.getString("logicName");
        int jobId = batchParam.getInt("jobId");
        JSONArray executeParam = batchParam.getJSONArray("executeParam");
        LOGGER.info((Object)("======\u5f00\u59cb\u6267\u884c\u6279\u91cf[" + logicName + "]\u4e1a\u52a1\u6d41\u7a0b======"));
        batchParam.remove("executeParam");
        JSONArray resultArray = executeParam;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            jobData.put("count", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id", jobId);
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress", 1);
            try {
                endData.put("data", (Object)jobData);
                String result = this.logicService.xtSave("addJobBuniness", endData.toString());
                JSONObject results = new JSONObject(result);
                int id = results.getInt("jobId");
                jobData.put("id", id);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            JSONArray paramArray = new JSONArray();
            for (int i = 0; i < resultArray.length(); ++i) {
                JSONObject jsonObject = (JSONObject)resultArray.get(i);
                JSONObject executeContent = new JSONObject(jsonObject.getString("f_execute_content"));
                paramArray.put((Object)executeContent);
            }
            LOGGER.info((Object)("\u7ec4\u7ec7\u6570\u636e:" + paramArray));
            paramArray.forEach(item -> executorService.execute(() -> {
                try {
                    JSONObject exeParam = new JSONObject();
                    exeParam.put("con", item);
                    exeParam.put("logicName", (Object)logicName);
                    this.runLeiSureLogic("batchjobtemplate", exeParam, countData);
                    int progress = ai.getAndIncrement();
                    LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u4e2d\uff1a\u603b\u6570\uff1a" + countData.getInt("total") + ", \u5f53\u524d\uff1a" + progress + "======="));
                    jobData.put("progress", progress);
                    if (countData.getInt("total") == progress || countData.getInt("total") == 3 * progress || 2 * countData.getInt("total") == 3 * progress) {
                        endData.put("data", (Object)jobData);
                        String result = this.logicService.xtSave("addJobBuniness", endData.toString());
                        JSONObject inresults = new JSONObject(result);
                        int getId = inresults.getInt("jobId");
                        if (getId != 0) {
                            jobData.put("id", getId);
                        }
                        LOGGER.info((Object)("\u66f4\u65b0jobData:" + jobData.toString()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }));
            LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u7ed3\u675f\uff0c\u9519\u8bef\u6570\uff1a" + countData.getInt("errorCount") + "======="));
            return "" + (countData.getInt("total") - countData.getInt("errorCount"));
        }
        LOGGER.info((Object)("======\u4e1a\u52a1\u6d41\u7a0b[" + logicName + "]\u6279\u91cf\u6267\u884c\u672a\u6267\u884c\uff1a\u6ca1\u6709\u9700\u8981\u8f6e\u8be2\u7684\u6570\u636e"));
        return "0";
    }
}

