/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.af.plugins.CommonTools;
import com.af.plugins.DataSectionTools;
import com.af.plugins.DateTools;
import com.af.plugins.timeoutReturn.TimeCache;
import com.aote.logic.LogicServer;
import com.aote.plugins.impexp.FileManager;
import com.aote.rs.SqlService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="handPlanAudit")
public class BatchAuditMeterRead {
    static Logger log = Logger.getLogger(BatchAuditMeterRead.class);
    @Autowired
    private TimeCache timeCache;
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlService sqlService;

    @POST
    @Path(value="allAudit")
    public JSONObject allAudit(String values) throws Exception {
        log.debug((Object)"\u5f00\u59cb\u6279\u91cf\u5904\u7406\u5ba1\u6838");
        JSONObject jsonObject = new JSONObject();
        JSONObject data = new JSONObject(values);
        String uuid = data.getString("uuid");
        try {
            log.debug((Object)("\u5168\u90e8\u6284\u8868\u5ba1\u6838" + data));
            this.timeCache.setCahce(uuid, jsonObject);
            JSONArray condition = data.getJSONArray("condition");
            int n = 0;
            int success = 0;
            int fail = 0;
            for (int i = 0; i < condition.length(); ++i) {
                JSONObject row = condition.getJSONObject(i);
                JSONObject params = new JSONObject();
                params.put("f_hand_id", row.get("f_hand_id"));
                params.put("f_tablebase", row.get("f_tablebase"));
                params.put("f_meter_classify", row.get("f_meter_classify"));
                params.put("f_meter_brand", row.get("f_meter_brand"));
                params.put("f_audit_person", data.get("f_audit_person"));
                try {
                    this.logicServer.run("handPlanAudit", params);
                    ++success;
                }
                catch (Exception e) {
                    ++fail;
                    log.debug((Object)("\u5355\u6761\u6284\u8868\u5f02\u5e38" + row.get("f_hand_id")), (Throwable)e);
                }
                jsonObject.put("n", ++n);
                this.timeCache.setCahce(uuid, jsonObject);
            }
            jsonObject.put("n", n);
            jsonObject.put("sum", condition.length());
            jsonObject.put("success", success);
            jsonObject.put("fail", fail);
            jsonObject.put("msg", (Object)"\u6284\u8868\u6279\u91cf\u5ba1\u6838\u5904\u7406\u5b8c\u6210");
            this.timeCache.setCahce(uuid, jsonObject);
        }
        catch (Exception e) {
            log.debug((Object)"\u6284\u8868\u6279\u91cf\u5ba1\u6838\u5904\u7406\u5f02\u5e38", (Throwable)e);
            jsonObject.put("error", (Object)"\u6284\u8868\u6279\u91cf\u5ba1\u6838\u5904\u7406\u5f02\u5e38");
            this.timeCache.setCahce(uuid, jsonObject);
        }
        return jsonObject;
    }

    @POST
    @Path(value="cardBatchCommonEnter")
    public JSONObject cardBatchCommonEnter(String values) throws Exception {
        log.debug((Object)"\u5361\u8868\u6279\u91cf\u6284\u8868");
        JSONObject jsonObject = new JSONObject();
        JSONObject data = new JSONObject(values);
        String uuid = data.getString("uuid");
        try {
            log.debug((Object)("\u5361\u8868\u6279\u91cf\u6284\u8868\u5f00\u59cb:" + values));
            this.timeCache.setCahce(uuid, jsonObject);
            JSONArray datas = new FileManager().read(data.getString("filepath"), "batchCardEnter.json");
            JSONArray array = new DataSectionTools().get(datas.toString(), Integer.valueOf(1000));
            int n = 0;
            int success = 0;
            int fail = 0;
            ArrayList<Integer> failArr = new ArrayList<Integer>();
            for (int i = 0; i < array.length(); ++i) {
                JSONArray jsonArray = array.getJSONArray(i);
                HashMap<Integer, JSONObject> map = new HashMap<Integer, JSONObject>();
                ArrayList<Integer> arr = new ArrayList<Integer>();
                for (int j = 0; j < jsonArray.length(); ++j) {
                    JSONObject row = jsonArray.getJSONObject(j).getJSONObject("batchCard");
                    arr.add(row.getInt("id"));
                    map.put(row.getInt("id"), row);
                }
                JSONObject sqlParam = new JSONObject();
                String ids = arr.toString().replace("[", "(").replace("]", ")");
                sqlParam.put("condition", (Object)("f_meter_state = '\u672a\u6284\u8868' and id in " + ids));
                sqlParam.put("orderitem", (Object)"id");
                JSONArray cardData = new JSONArray(this.sqlService.txExecute("getCardPlan", 1, 9999999, new JSONObject().put("data", (Object)sqlParam).toString()));
                for (int j = 0; j < cardData.length(); ++j) {
                    try {
                        JSONObject row = cardData.getJSONObject(j);
                        JSONObject excelDate = (JSONObject)map.get(row.getInt("id"));
                        String tablebase = excelDate.getString("f_tablebase");
                        String last_tablebase = String.valueOf(row.get("f_last_tablebase"));
                        String initial_base = String.valueOf(row.get("f_initial_base"));
                        if (!tablebase.matches("[0-9]+")) {
                            throw new RuntimeException("\u672c\u671f\u5e95\u6570\u53ea\u80fd\u662f\u6574\u6570");
                        }
                        if (CommonTools.sub((Object)tablebase, (Object)last_tablebase).intValue() < 0) {
                            throw new RuntimeException("\u672c\u671f\u5e95\u6570\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u671f\u5e95\u6570");
                        }
                        row.put("f_input_date", (Object)excelDate.getString("f_input_date"));
                        String f_last_input_date = String.valueOf(row.get("f_last_input_date"));
                        if ("".equals(f_last_input_date) || "null".equals(f_last_input_date)) {
                            row.put("f_last_input_date", (Object)excelDate.getString("f_input_date"));
                        }
                        row.put("f_operate_date", (Object)DateTools.getNow2());
                        row.put("f_orgid", (Object)data.getString("f_orgid"));
                        row.put("f_orgname", (Object)data.getString("f_orgname"));
                        row.put("f_depid", (Object)data.getString("f_depid"));
                        row.put("f_depname", (Object)data.getString("f_depname"));
                        row.put("f_operatorid", (Object)data.getString("f_operatorid"));
                        row.put("f_operator", (Object)data.getString("f_operator"));
                        row.put("f_meter_state", (Object)"\u5df2\u6284\u8868");
                        String total_gas = String.valueOf(row.get("total_gas"));
                        row.put("f_total_gas", (Object)total_gas);
                        row.put("f_total_fee", row.get("total_fee"));
                        row.put("f_tablebase", (Object)tablebase);
                        BigDecimal shengyu_gas = CommonTools.sub((Object)total_gas, (Object)CommonTools.sub((Object)tablebase, (Object)initial_base), (int)2);
                        row.put("f_shengyu_gas", (Object)shengyu_gas);
                        row.put("f_instantaneous_flow", excelDate.get("f_instantaneous_flow"));
                        row.put("f_pressure", excelDate.get("f_pressure"));
                        row.put("f_temperature", excelDate.get("f_temperature"));
                        row.put("f_flowmeter_capacity", excelDate.get("f_flowmeter_capacity"));
                        row.put("f_valve_switch", excelDate.get("f_valve_switch"));
                        this.logicServer.run("cardCommonEnter", row);
                        ++success;
                    }
                    catch (Exception e) {
                        ++fail;
                        int id = cardData.getJSONObject(j).getInt("id");
                        failArr.add(id);
                        log.debug((Object)("\u5355\u6761\u5361\u8868\u6284\u8868\u5f02\u5e38:" + id), (Throwable)e);
                    }
                    ++n;
                }
            }
            jsonObject.put("n", n);
            jsonObject.put("success", success);
            jsonObject.put("fail", fail);
            jsonObject.put("msg", (Object)"\u5361\u8868\u6284\u8868\u6279\u91cf\u5904\u7406\u5b8c\u6210");
            this.timeCache.setCahce(uuid, jsonObject);
        }
        catch (Exception e) {
            log.debug((Object)"\u5361\u8868\u6279\u91cf\u6284\u8868\u5904\u7406\u5f02\u5e38", (Throwable)e);
            jsonObject.put("error", (Object)"\u5361\u8868\u6279\u91cf\u6284\u8868\u5904\u7406\u5f02\u5e38");
            this.timeCache.setCahce(uuid, jsonObject);
        }
        log.debug((Object)("\u5361\u8868\u6284\u8868\u6279\u91cf\u8fd4\u56de:" + jsonObject));
        return jsonObject;
    }
}

