/*
 * Decompiled with CFR 0.152.
 */
package com.af.timingJob;

import com.aote.logic.LogicServer;
import com.aote.util.ResourceHelper;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.transaction.Transactional;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Transactional
public class BatchBusinessAwaitServer {
    static Logger log = Logger.getLogger(BatchBusinessAwaitServer.class);
    private static final Integer processors = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService executorService = Executors.newFixedThreadPool(processors * 2 + 1);
    static JSONObject configJson;
    @Autowired
    private LogicServer logicServer;
    private static final String THREAD_PRODUCE = "\u83b7\u53d6\u5f85\u6267\u884c\u7684\u4efb\u52a1";
    private static final String THREAD_CONSUME = "\u6267\u884c\u4efb\u52a1";
    private PublicResource resource = new PublicResource();
    private String queryLogicName;
    private String businessLogicName;
    private String jsonKey;

    public void setQueryLogicName(String queryLogicName) {
        this.queryLogicName = queryLogicName;
    }

    public void setBusinessLogicName(String businessLogicName) {
        this.businessLogicName = businessLogicName;
    }

    public void setJsonKey(String jsonKey) {
        this.jsonKey = jsonKey;
    }

    public void action() throws IOException {
        configJson = new JSONObject(ResourceHelper.getString((String)"config.json"));
        if (configJson.optBoolean(this.jsonKey, false)) {
            new Thread(new Task(THREAD_PRODUCE)).start();
            new Thread(new Task(THREAD_CONSUME)).start();
        }
    }

    @Transactional
    public class PublicResource {
        private JSONArray job = new JSONArray();
        private final Object object = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Transactional
        public void increase() throws Exception {
            Object object = this.object;
            synchronized (object) {
                while (!this.job.isEmpty() && configJson.optBoolean(BatchBusinessAwaitServer.this.jsonKey, false)) {
                    this.object.wait();
                }
                this.job = (JSONArray)BatchBusinessAwaitServer.this.logicServer.run(BatchBusinessAwaitServer.this.queryLogicName, "{data:{}}");
                if (this.job.length() == 0) {
                    Thread.sleep(600000L);
                } else {
                    System.out.println("--" + Thread.currentThread().getName() + ":\u751f\u4ea7\u4e86\u4e00\u4e2a\u4efb\u52a1.");
                }
                this.object.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrease() throws Exception {
            Object object = this.object;
            synchronized (object) {
                while (this.job.length() == 0) {
                    this.object.wait();
                }
                CountDownLatch latch = new CountDownLatch(this.job.length());
                this.job.forEach(item -> executorService.execute(() -> {
                    try {
                        JSONObject searchItem = (JSONObject)item;
                        BatchBusinessAwaitServer.this.logicServer.run(BatchBusinessAwaitServer.this.businessLogicName, searchItem);
                    }
                    catch (Exception exception) {
                        log.debug((Object)exception);
                    }
                    finally {
                        latch.countDown();
                    }
                }));
                latch.await();
                this.job = new JSONArray();
                System.out.println("--" + Thread.currentThread().getName() + ":\u6d88\u8d39\u4e86\u4e00\u4e2a\u4efb\u52a1.");
                this.object.notifyAll();
            }
        }
    }

    class Task
    implements Runnable {
        private final String threadName;

        Task(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (BatchBusinessAwaitServer.THREAD_PRODUCE.equals(this.threadName)) {
                            BatchBusinessAwaitServer.this.resource.increase();
                            continue;
                        }
                        if (!BatchBusinessAwaitServer.THREAD_CONSUME.equals(this.threadName)) continue;
                        BatchBusinessAwaitServer.this.resource.decrease();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        Thread.sleep(3600000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        continue;
                    }
                }
                break;
            }
        }
    }
}

