package util;

import com.af.plugins.sms.PropertiesReaderPlugin;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;

/**
 * 数据字典
 */
public class DictionaryUtil {
    private static Map dictionarys;

    static {
        //读取dictionary.properties配置文件
        Properties props = new Properties();
        try {
            props.load(new InputStreamReader(PropertiesReaderPlugin.class.getResourceAsStream("/dictionary.properties"),StandardCharsets.UTF_8));
            //把键值对存入dictionary
            dictionarys = props;
        } catch (IOException e) {
            System.out.println("未读取到dictionary.properties文件");
        }
    }
    public String getValue(String key){
        if (key == null){
            return null;
        }
        if(dictionarys.containsKey(key)){
            return String.valueOf(dictionarys.get(key));
        } else {
            return key;
        }
    }
}
