package meter;

import com.af.plugins.RestTools;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class FixAccptionUtil {
    private static final Logger LOGGER = Logger.getLogger(FixAccptionUtil.class);

    /**
     * 测试地址
     */
    private static final String TEST_URL = "http://localhost:8400/rs/logic/";
    /**
     * 正式地址
     */
    private static final String STANDARD_URL = "http://localhost:8400/rs/logic/";

    public static JSONObject getFixAccptionItem(String type, String logicName,JSONObject params){
        String url;
        url = "http://"+type+ "/rs/logic/"+ logicName;

        JSONObject result = new JSONObject();
        try {
            Object code = null;
            int resultcode = 200;
            String post = RestTools.post(url, params);
            if(post.indexOf("{")<0){
                resultcode=200;
            }else{
                JSONObject jsonObject = new JSONObject(post);
                if(jsonObject.has("status")){
                    code = jsonObject.get("status");
                }else{
                    resultcode=500;
                }
                if(code instanceof Integer){
                    resultcode = (int) code;
                }else if(code instanceof String){
                    resultcode =  Integer.parseInt((String) code);
                }else{
                    resultcode=500;
                }
            }
            if(resultcode == 200){
                result.put("code",200);
                result.put("msg",post);
            }else{
                result.put("code",500);
                result.put("msg","批量收费: "+params.get("f_userinfo_code")+"收费失败! ");
            }
        } catch (Exception e){
            result.put("code",500);
            result.put("msg","批量收费: "+params.get("f_userinfo_code")+"收费失败! ");
        }
        return result;
    }
}
