SELECT
  *
FROM
  (

    SELECT
      u1.f_userinfo_id,				                            --用户id
	  u1.f_userfiles_id,										--气表id
      u2.f_userinfo_code,				                        --用户编号
	  u2.f_user_name,					                        --用户名
      u3.f_address,						                        --用户地址
	  u1.f_user_type,                                           --用户类型
      u1.f_gasproperties,                                       --用气性质
      u1.f_meternumber,				                            --表号
	  u1.f_meter_base,                                          --气表底数
	  u1.f_total_fee,                                           --累够金额
	  u1.f_balance_amount,                                      --表上余额
	  u1.f_startuse_date,					                     --启用日期
	  u4.f_meter_brand,                                         --气表品牌
	  u1.f_table_state,                                         --气表品牌
	  u1.f_filialeid,											--组织id（查询用）
	  u1.f_orgname,											    --组织名称	(显示用，本应根据f_filialeid关联，组织名称，
	                                                                        --现在先显示操作公司（f_orgname）)
      u6.f_signal,                                              --信号强度
      u6.f_batteryLevel,	                                    --电压
	  u6.f_snr,                                                 --噪音比
	  u6.f_magneticInterference,                                --磁干扰

	  u6.angleY,  --角度
	  u6.valveNoActionDay,   --阀门无动作天数
	  u6.noSignalDay,   --未通讯天数
	  u6.noUseGasDay,   --未用气天数
	  u6.useGasByThisMonth,   --本月用量
	  u6.useGasByLastMonth,    --上月用量
	  u6.useGasByDay,   --日用量
	  u6.useGasByYear,   --年用量
	  u6.flowmeterTemperature,   --温度
	  u6.f_jval,  --表内余额


      case
      when u6.f_valveState = 1 then '关阀'
      when u6.f_valveState = 0 then '开阀'
      else '未上报' end f_valvestate	                          --阀门状态
	  --需要表上的其他最新信息，依次往下写即可
    FROM
      t_userfiles u1
      left join t_userinfo u2 ON u1.f_userinfo_id= u2.f_userinfo_id
	  left join t_user_address u3 on u1.f_useraddress_id=u3.id
      left join t_gasbrand u4 ON u1.f_gasbrand_id= u4.id
      left join (select f_userfiles_id,max(id) maxid from t_meteread group by f_userfiles_id) u5 on u1.f_userfiles_id=u5.f_userfiles_id
      left join t_meteread u6 on u5.maxid=u6.id
      WHERE u1.f_meter_classify='物联网表'
  ) t_userfiles
where {condition}
ORDER BY
f_userfiles_id DESC
