SELECT * FROM(
SELECT f_userinfo_id,
  f_userinfo_code,
  f_user_id,
  f_user_name,                --用户姓名
  f_user_phone,                --用户电话
  f_user_type,                --用户类型
  f_cost_type,
  f_meter_classify,
  f_meter_brand,              --表类型
  f_address,                  --地址
  sum(overdue) overdue,        --滞纳金
  sum(f_oughtamount) f_oughtamount,--应交气量
  sum(f_oughtfee) f_oughtfee,  --应交气费
  sum(f_oughtfee + overdue) as qianfei, --应交
  f_balance,                   --账户结余
  min(f_hand_date) start_date, --欠费抄表初始日期
  max(f_hand_date) end_date,   --欠费抄表结束日期
  f_inputtor,                  --抄表员
  --银行信息
  f_bank_name,
  f_bank_accopen,
  f_bank_account,
  f_bank_idnumber,
  --分公司信息
  f_outlets,
  f_filiale,
  f_filialeids,
  f_orgstr
FROM(
 SELECT f_userinfo_id,
    f_userinfo_code,
    f_user_name,
    f_user_phone,
    f_user_type,
    f_cost_type,
    f_meter_brand,
    f_meter_classify,
    f_address,
    f_bank_accopen,
    f_bank_name,
    f_bank_account,
    f_bank_idnumber,
    handplan_id,                                            --抄表记录id
    f_last_tablebase,                                        --上期指数
    f_tablebase,                                            --本期指数
    f_hand_date,                                            --抄表日期
    f_input_date,
    f_user_id,
    f_surplus_gas,
    f_haircut_gas,
    f_oughtamount,    --应交气量  convert(decimal(18,2),f_oughtamount)  ROUND(f_oughtamount,2)
    f_loss_gas,        --输损量 convert(decimal(18,2),f_loss_gas) ROUND(f_loss_gas,2)
    f_share_gas,        --承担量 convert(decimal(18,2),f_share_gas) ROUND(f_share_gas,2)
    ROUND(f_oughtfee-f_debt_money,2) f_oughtfee,            --实际应交金额 convert(decimal(18,2),f_oughtfee-f_debt_money) ROUND(f_oughtfee-f_debt_money,2)
    f_debt_money,    --已交气费 convert(decimal(18,2),f_debt_money) ROUND(f_debt_money,2)
    f_charge_money, --已交总金额 convert(decimal(18,2),f_charge_money) ROUND(f_charge_money,2)
    f_selloverdue,  --已交滞纳金 convert(decimal(18,2),f_selloverdue) ROUND(f_selloverdue,2)
    f_allfee,            --总应交金额 convert(decimal(18,2),f_oughtfee) ROUND(f_oughtfee,2)
    f_totalowe_gas, -- convert(decimal(18,2),f_totalowe_gas) ROUND(f_totalowe_gas,2)
    f_totalowe_fee, -- convert(decimal(18,2),f_totalowe_fee) ROUND(f_totalowe_fee,2)
    f_whether_pay,                                            --是否缴费
    f_end_date,                                            --截止日期
    CASE WHEN overduedays<1 THEN 0 ELSE overduedays END overduedays,    --滞纳天数
    f_balance,    --余额
    f_inputtor,
        --滞纳天数小于0，不计算滞纳金，返回0
    convert(decimal(18,2),
    CASE WHEN overduedays<=0 THEN
        0
    ELSE
      --滞纳金天数大于0，若应交金额小于0
      CASE WHEN overduedays*zhinajinbilv*(f_oughtfee-f_debt_money -f_balances)<0
      THEN
        0
      ELSE
        --判断应交金额是否小于0
        (CASE WHEN overduedays*zhinajinbilv*(f_oughtfee-f_debt_money -f_balances)>=f_oughtfee-f_debt_money -f_balances
         THEN
           CASE WHEN f_oughtfee-f_debt_money -f_balances<0
           THEN 0
           ELSE f_oughtfee-f_debt_money -f_balances
           END
         ELSE
           overduedays*zhinajinbilv*(f_oughtfee-f_debt_money -f_balances)
         END)
      END
    END) overdue,
    splitNum,
    f_outlets,
    f_filiale,
    f_filialeids,
    f_orgstr
FROM(
  SELECT id as handplan_id,
    f_last_tablebase,
    f_tablebase,
    h.f_hand_date,
    h.f_input_date,
    f_oughtamount,
    f_oughtfee,
    isnull(f_debt_money,0) f_debt_money,
    isnull(f_charge_money,0) f_charge_money,
    isnull(f_selloverdue,0) f_selloverdue,
    f_oughtfee f_allfee,
    f_whether_pay,
    f_loss_gas,
    h.f_end_date,
    h.f_user_id,
    f_surplus_gas,
    f_haircut_gas,
    f_share_gas,
    f_totalowe_fee,
    f_totalowe_gas,
    f_overdue,
    h.f_userinfo_id,
    h.f_userinfo_code,
    u.f_user_name,
    u.f_user_phone,
    h.f_user_type,
    h.f_meter_brand,
    f.f_meter_classify,
    h.f_address,
    b.f_bank_accopen,
    b.f_bank_name,
    b.f_bank_account,
    b.f_bank_idnumber,
    u.f_cost_type,
    u.f_balance,
    case when u.f_balance<0 then 0 else u.f_balance end f_balances,
    f.f_inputtor,
    --NVL(f_debt_money,0) f_debt_money,
    --isnull(f_charge_money,0) f_charge_money,
    --isnull(f_selloverdue,0)  f_selloverdue,
     --floor(sysdate - h.f_end_date) overduedays, --滞纳天数 oracle
    DATEDIFF(dd,f_end_date,getdate()) overduedays, --滞纳天数 sql server
    CASE WHEN h.f_user_type='民用'
      THEN (SELECT cast(value as float) FROM  t_singlevalue WHERE name='民用违约金' and f_filialeids=u.f_filialeids)
    ELSE
      (SELECT cast(value as float) FROM  t_singlevalue WHERE name='非民用违约金' and f_filialeids=u.f_filialeids)
    END zhinajinbilv,
    u.f_outlets,
    u.f_filiale,
    u.f_filialeids,
    u.f_orgstr
  FROM t_handplan h
  LEFT JOIN (
    SELECT f_hand_id,SUM(f_debt_money) f_debt_money,
      SUM(f_charge_money) f_charge_money,SUM(f_overdue) f_selloverdue
    FROM t_sellinghand
    WHERE f_state = '有效'
    GROUP BY f_hand_id
  ) sh on h.id = sh.f_hand_id
  LEFT JOIN t_userinfo u
      ON h.f_userinfo_id = u.f_userinfo_id
  LEFT JOIN t_userfiles f
      ON h.f_userinfo_id = f.f_userinfo_id
  LEFT JOIN t_infobank b
      ON b.f_userinfo_id = u.f_userinfo_id
  WHERE
    f_whether_pay='否' AND f_hand_state = '有效' and
    h.f_meter_state = '已抄表' AND f_oughtfee>0
) P LEFT JOIN(
  SELECT f_meter_id,count(*) AS splitNum
  FROM t_userfiles
  GROUP BY f_meter_id
) S ON P.f_user_id = S.f_meter_id
) m
GROUP BY f_userinfo_id,f_userinfo_code,f_user_id,f_user_name,f_user_phone,f_user_type,f_meter_brand,f_meter_classify,f_address,f_balance,f_inputtor,f_bank_name,f_bank_accopen,f_bank_account,f_bank_idnumber,f_outlets,f_filiale,f_filialeids,f_orgstr,f_cost_type
) res WHERE {condition}
ORDER BY f_address DESC
