/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

public class DateProcess {
    public boolean isAfter(String date, Integer add, String forMate) {
        if (date == null || add == null) {
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.now().isAfter(parse.plusMonths(add.intValue()));
    }

    public String addDate(String date, Integer add, String forMate) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return parse.plusMonths(add.intValue()).format(dtf);
    }

    public boolean isDoIt(String date, String period, String forMate) {
        if (date == null || period == null) {
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        LocalDateTime now = LocalDateTime.now();
        parse = parse.plusMonths(Integer.parseInt(period));
        return now.getYear() == parse.getYear() && now.getMonth() == parse.getMonth() && now.getDayOfMonth() == parse.getDayOfMonth();
    }

    public String getNowMonthFirst() {
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getNowMonthLast() {
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getMonthFirst(String date) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.of(parse.with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getMonthLast(String date) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.of(parse.with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String yearMonthFormatterDate(String date) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM");
        DateTimeFormatter ove = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDate.parse(date, dtf).atStartOfDay();
        return parse.format(ove);
    }
}

