/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

public class DateProcess {
    public boolean isAfter(String date, Integer add, String forMate) {
        if (date == null || add == null) {
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.now().isAfter(parse.plusMonths(add.intValue()));
    }

    public String addDate(String date, Integer add, String forMate) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return parse.plusMonths(add.intValue()).format(dtf);
    }

    public boolean isDoIt(String date, String period, String forMate) {
        if (date == null || period == null) {
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        LocalDateTime now = LocalDateTime.now();
        parse = parse.plusMonths(Integer.parseInt(period));
        return now.getYear() == parse.getYear() && now.getMonth() == parse.getMonth();
    }

    public String getNowMonthFirst() {
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getNowMonthLast() {
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
}

