/*
 * Decompiled with CFR 0.152.
 */
package meter;

import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.rs.mapper.WebException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

public class SettleTools {
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    static Logger log = Logger.getLogger(EntityServer.class);

    public static String getAllValue(JSONArray json) {
        StringBuffer sbs = new StringBuffer();
        for (int i = 0; i < json.length(); ++i) {
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = map.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if (!iterator.hasNext()) continue;
                sbs.append(",");
            }
            if (i == json.length() - 1) {
                sbs.append(")");
                continue;
            }
            sbs.append("),");
        }
        return sbs.toString();
    }

    public static String getjsonAllFields(JSONArray json) {
        StringBuffer sbs = new StringBuffer();
        int i = 0;
        if (i < json.length()) {
            sbs.append("(");
            sbs.append("f_userinfo_code,");
            sbs.append("f_meternumber,");
            sbs.append("f_tablebase");
            sbs.append(")");
        }
        return sbs.toString().replace(",)", ")");
    }

    public static String getjsonAllValue(JSONArray json) {
        StringBuffer sbs = new StringBuffer();
        for (int i = 0; i < json.length(); ++i) {
            sbs.append("(");
            JSONObject maps = (JSONObject)json.get(i);
            JSONObject map = (JSONObject)maps.get("batchsttle");
            if (map.isNull("f_userinfo_code")) {
                sbs.append("'0'");
            } else {
                String f_userinfo_code = (String)map.get("f_userinfo_code");
                sbs.append(f_userinfo_code);
            }
            sbs.append(",");
            if (map.isNull("f_meternumber")) {
                sbs.append("'0'");
            } else {
                String f_meternumber = (String)map.get("f_meternumber");
                sbs.append(f_meternumber);
            }
            sbs.append(",");
            if (map.isNull("f_tablebase")) {
                sbs.append(0);
            } else {
                sbs.append(map.get("f_tablebase"));
            }
            if (i == json.length() - 1) {
                sbs.append(")");
                continue;
            }
            sbs.append("),");
        }
        return sbs.toString().replace(",)", ")");
    }

    public static String getAllFields(JSONArray json) {
        StringBuffer sbs;
        block1: {
            sbs = new StringBuffer();
            int i = 0;
            if (i >= json.length()) break block1;
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                sbs.append(key);
                if (!iterator.hasNext()) continue;
                sbs.append(",");
            }
            sbs.append(")");
        }
        return sbs.toString();
    }

    public static List<String[]> getExcelData(String filepath) {
        List<String[]> data = null;
        InputStream is = null;
        try {
            filepath = filepath.replaceAll("\\\\", "/");
            String jsonString = "{\"filepath\":\"" + filepath + "\"}";
            HttpEntity httpEntity = RestTools.postHttpEntity((String)"/rs/file/getUploadFile", (JSONObject)new JSONObject(jsonString));
            is = httpEntity.getContent();
        }
        catch (Exception e) {
            throw new WebException(500, filepath + "\u60a8\u6240\u9009\u7684\u6587\u4ef6\u4e0d\u5b58\u5728!!!");
        }
        filepath = filepath.replace("\\", "/");
        String fileName = filepath.split("/")[filepath.split("/").length - 1];
        if (fileName.endsWith(XLS) || fileName.endsWith(XLSX)) {
            try {
                data = SettleTools.readExcel(is, fileName);
            }
            catch (IOException e) {
                throw new WebException(500, "\u6587\u4ef6\u89e3\u6790\u9519\u8bef!!!");
            }
        } else {
            throw new WebException(500, "\u975eexcel\u6587\u4ef6\u6682\u65f6\u672a\u4f5c\u5904\u7406.\u5982\u6709\u9700\u6c42,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458!!!!");
        }
        return data;
    }

    public static int getExcelLine(String filepath) {
        List<String[]> data = SettleTools.getExcelData(filepath);
        if (data.size() > 0) {
            return data.size();
        }
        return 0;
    }

    public static int getExcelParseJson(String filepath) {
        List<String[]> data = SettleTools.getExcelData(filepath);
        if (data.size() > 0) {
            String[] strings = data.get(0);
            return strings.length;
        }
        return 0;
    }

    public static List<String[]> readExcel(InputStream is, String fileName) throws IOException {
        SettleTools.checkFile(is);
        Workbook workbook = SettleTools.getWorkBook(is, fileName);
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (workbook != null) {
            for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
                Sheet sheet = workbook.getSheetAt(sheetNum);
                if (sheet == null) continue;
                int firstRowNum = sheet.getFirstRowNum();
                int lastRowNum = sheet.getLastRowNum();
                if (sheetNum == 0) {
                    --firstRowNum;
                }
                int lastCellNum = 0;
                for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; ++rowNum) {
                    Row row = sheet.getRow(rowNum);
                    if (row == null) continue;
                    int firstCellNum = row.getFirstCellNum();
                    if (rowNum == 0) {
                        lastCellNum = row.getPhysicalNumberOfCells();
                    }
                    String[] cells = new String[lastCellNum];
                    for (int cellNum = firstCellNum; cellNum < lastCellNum; ++cellNum) {
                        Cell cell = row.getCell(cellNum);
                        cells[cellNum] = SettleTools.getCellValue(cell);
                    }
                    if (!SettleTools.validateCells(cells)) continue;
                    list.add(cells);
                }
            }
            workbook.close();
        }
        return list;
    }

    private static void checkFile(InputStream is) throws IOException {
        if (null == is) {
            log.error((Object)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            throw new FileNotFoundException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
    }

    private static Workbook getWorkBook(InputStream is, String fileName) {
        HSSFWorkbook workbook = null;
        try {
            if (fileName.endsWith(XLS)) {
                workbook = new HSSFWorkbook(is);
            } else if (fileName.endsWith(XLSX)) {
                workbook = new XSSFWorkbook(is);
            }
        }
        catch (IOException e) {
            log.info((Object)e.getMessage());
        }
        return workbook;
    }

    public static boolean validateCells(String[] cells) {
        for (String str : cells) {
            if (str == null || "".equals(str)) continue;
            return true;
        }
        return false;
    }

    private static String getCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        if (cell.getCellType() == 0) {
            cell.setCellType(1);
        }
        switch (cell.getCellType()) {
            case 0: {
                cellValue = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case 1: {
                cellValue = String.valueOf(cell.getStringCellValue());
                break;
            }
            case 4: {
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 2: {
                cellValue = String.valueOf(cell.getCellFormula());
                break;
            }
            case 3: {
                cellValue = "";
                break;
            }
            case 5: {
                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                cellValue = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return cellValue;
    }

    public static double getValue(String value) {
        if (value == null || "".equals(value)) {
            return 0.0;
        }
        Double doubles = new Double(value);
        double ceil = Math.round(doubles);
        return new Double(ceil);
    }

    public static String checkData(String json, String json2) {
        if (json == null || json2 == null) {
            return "";
        }
        String newjson = json.substring(1, json.length() - 1) + ",''";
        String newjson2 = json2.substring(1, json2.length() - 1) + ",''";
        String[] split = newjson.split(",");
        String[] split1 = newjson2.split(",");
        List<String> list1 = Arrays.asList(split1);
        ArrayList<String> list2 = new ArrayList<String>();
        for (String t : split) {
            if (list1.contains(t)) continue;
            list2.add(t);
        }
        if (list2.size() == 0) {
            return "";
        }
        String[] strings = new String[list2.size()];
        Object[] strarr = list2.toArray(strings);
        String join = StringUtils.join((Object[])strarr, (String)",");
        return join;
    }
}

