SELECT
  *
FROM
  (
    SELECT
      ui.f_userinfo_code,				                            --用户编号
      ui.f_userinfo_id,
      ui.f_user_name,					                            --用户名
      gb.f_alias,                                         --表厂别名
      uf.f_meter_base,				                            --气表底数
      isnull(s.f_collection,0) f_collection,				--累计充值金额
      h.f_oughtamount f_initial_base,	--累计用气量
      h.f_oughtfee AS f_total_fee, --累计用气金额
      uf.f_balance_amount f_balance,                      --账户结余
      uf.f_input_date,

      ui.f_address,						                            --用户地址
      ui.f_area,                                          --辖区
      ui.f_slice_area,                                    --片区
      ui.f_street,                                        --街道
      ui.f_residential_area,                              --小区

      uf.f_user_id,						                            --表编号
      uf.f_meternumber,				                            --表号
      ui.f_user_type,                                     --用户类型
      ui.f_gasproperties,                                 --用气性质
      ISNULL(uf.f_position,'未知') AS f_position,					--表安装位置
      m1.f_signal, --信号强度
      m1.f_batteryLevel,	--电压
      m1.f_valveState,	--阀门状态
      gb.id AS f_gasbrand_id,	                            --品牌识别列
      gb.f_meter_brand,				                            --气表品牌
      gm.id AS f_gasmodel_id,	                            --型号识别列
      gm.f_meter_style,				                            --气表型号
      gb.f_meter_type,				                            --气表类型
      uf.f_table_state,				                            --气表状态

      ISNULL(uf.f_valve_state,'未知') AS f_valve_state, 		--阀门状态
      ui.f_createfile_date,                               --建档日期
      ui.f_orgstr,                                        --分公司代号
      ui.f_filialeids,
      uf.f_gas_date,
      uf.f_filiale,
      cast((select f_parameter_name+',' from t_userparameter
      where f_parameter_state='标记' and f_meternumber=uf.f_meternumber for xml path('')) as varchar)
        f_parameter_name,
      case when (select f_parameter_name+',' from t_userparameter
      where f_parameter_state='标记' and f_meternumber=uf.f_meternumber for xml path('')) is null then '正常用户'
      else '标记用户' end f_parameter_state,
      case when m1.f_signal<=-101 or m1.f_batterylevel<4.00 or m1.f_magneticinterference=1 or m1.f_cycleshutvalue=1
                or m1.f_overcurrentprotection=1 or m1.f_leakageflag=1 or m1.f_splitalarm=1 or m1.f_xtipllstopflag=1 then '异常用户'
      else '正常用户' end f_userfiles_state
    FROM
      t_userfiles uf
      LEFT JOIN t_userinfo ui ON (ui.f_userinfo_id= uf.f_userinfo_id)
      LEFT JOIN t_gasbrand gb ON (uf.f_gasbrand_id= gb.id)
      LEFT JOIN t_gasmodel gm ON (uf.f_gasmodel_id= gm.id)
      left join (
                  select f_meternumber,sum(f_collection) f_collection from t_sellinggas where f_charge_state='有效'
                  group by f_meternumber
                ) s on uf.f_meternumber=s.f_meternumber
      left join (
                  select f_meternumber,sum(f_oughtamount) f_oughtamount,sum(f_oughtfee) f_oughtfee from t_handplan where f_hand_state='有效'
                  group by f_meternumber
                ) h on uf.f_meternumber=h.f_meternumber
      left join (
                  select f_meternumber,sum(f_oughtamount) f_oughtamount,sum(f_oughtfee) f_oughtfee from t_handplan where f_hand_state='有效'
                  group by f_meternumber
                  ) c on uf.f_meternumber=c.f_meternumber
      left join (select f_meternumber,max(id) maxid from t_meteread group by f_meternumber) m on uf.f_meternumber=m.f_meternumber
      left join t_meteread m1 on m.maxid=m1.id
  ) t_userfiles
WHERE
  f_meter_type = '物联网表' and {condition}
ORDER BY
  f_userfiles_state,f_parameter_state,f_user_id DESC