select sum(main.pricesum)      pricesum,
       sum(main.instructsum)   instructsum,
       sum(main.noinstructsum) noinstructsum,
       sum(main.awaitsum)      awaitsum,
       sum(main.succsum)       succsum,
       sum(main.failsum)       failsum,
       CAST(CAST(sum(main.instructsum) * 1.0 * 100 / sum(main.pricesum) as decimal(10, 2)) as varchar(50)) +
       '%'                     production_rate,
       case
           when sum(main.instructsum) = 0 then '0.00%'
           else CAST(CAST(sum(main.awaitsum) * 1.0 * 100 / sum(main.instructsum) as decimal(10, 2)) as varchar(50)) +
                '%' end        await_rate,
       case
           when sum(main.instructsum) = 0 then '0.00%'
           else CAST(CAST(sum(main.succsum) * 1.0 * 100 / sum(main.instructsum) as decimal(10, 2)) as varchar(50)) +
                '%' end        succ_rate,
       f_operate_date
from (
         select case when pc.id is not null then 1 else 0 end             pricesum,
                case when ins.id is not null then 1 else 0 end            instructsum,
                case when ins.id is null then 1 else 0 end                noinstructsum,
                case when ins.f_instruct_state = '已发送' then 1 else 0 end  awaitsum,
                case when ins.f_instruct_state = '执行成功' then 1 else 0 end succsum,
                case when ins.f_instruct_state = '执行失败' then 1 else 0 end failsum,
                CONVERT(VARCHAR(10), pc.f_operate_date, 23)               f_operate_date
         from t_pricechange pc
                  left join t_userfiles uf on pc.f_userinfo_id = uf.f_userinfo_id
                  left join t_userinfo info on info.f_userinfo_id = uf.f_userinfo_id
                  left join t_user_address a on a.f_userinfo_id = info.f_userinfo_id
                  left join t_instruct ins on ins.f_data_id = pc.id and f_instruct_type = '远程调价'
         where uf.f_meter_classify = '物联网表'
           and pc.f_operate_date >= '{startDate}'
           and pc.f_operate_date <= '{endDate}'
           and {condition}
     ) main
group by f_operate_date
