select info.f_userinfo_code --用户编号
     , uf.f_meternumber   --表号
     , gb.f_meter_brand   --气表品牌
     , gm.f_meter_style   --气表型号
     , uf.f_table_state   --气表状态
     , uf.f_gasproperties --用气性质
     , sp.f_price_name   --气价名称
     , info.f_user_name   --用户名称
     , info.f_userinfo_id
     , a.f_address   --用户地址
     , a.f_residential_area   --用户小区
     , info.f_user_phone   --联系方式
     , mr.f_price mr_price   --上报价格
     , (select cast(f_price as varchar) + ';' from t_detailprice where f_stairprice_id = sp.id for xml path('')) f_price
     , case when ins.f_instruct_state = '已发送' then '已发送'
            when ins.f_instruct_state = '执行成功' then '执行成功'
            when ins.f_instruct_state = '执行失败' then '执行失败'
            when ins.f_instruct_state = '忽略冗余' then '忽略冗余'
            else '指令生成失败' end  f_instruct_state
from t_pricechange pc
         left join t_userfiles uf on pc.f_userinfo_id = uf.f_userinfo_id
         left join t_meteread mr on mr.id = uf.f_meteread_maxid
         left join t_stairprice sp on sp.f_price_id = uf.f_price_id and f_end_date > getdate() and sp.f_state = '有效' and uf.f_filialeids = sp.f_filialeids
         left join t_gasbrand gb on gb.id = uf.f_gasbrand_id
         left join t_gasmodel gm on gm.id = uf.f_gasmodel_id
         left join t_userinfo info on info.f_userinfo_id = uf.f_userinfo_id
         left join t_user_address a on a.f_userinfo_id = info.f_userinfo_id
         left join t_instruct ins on ins.f_data_id = pc.id and f_instruct_type = '远程调价'
where uf.f_meter_classify = '物联网表'
  and pc.f_operate_date >= '{startDate}'
  and pc.f_operate_date <= '{endDate}'
  and {condition}
