select * from (
select info.f_userinfo_code,
       info.f_user_name,
       ad.f_address,
       uf.f_filialeids,
       uf.f_meternumber,
       uf.f_user_type,
       1 c,
       dev.*
from t_userfiles uf
         left join t_userinfo info on info.f_userinfo_id = uf.f_userinfo_id
         left join t_user_address ad on ad.id = uf.f_useraddress_id
         left join (
    select
        sum(case  when f_devices_type in ('家用报警器','工业报警器') then isnull(f_dev_num,1) else  0 end) alter_num,
        sum( case  when f_devices_type in ('家用报警器','工业报警器') then isnull(f_ins_num,0) else  0 end) alter_ins_num,
        min( case  when f_devices_type in ('家用报警器','工业报警器') then f_due_date  end) alter_due_date,
        sum(case  when f_devices_type = '流量计' then isnull(f_dev_num,1) else  0 end) ll_num,
        min( case  when f_devices_type = '流量计' then f_due_date  end) ll_due_date,
        f_user_id
    from t_devices where f_devices_type in ('家用报警器','工业报警器','流量计')
        {device != null && device != $$ :
        $ and f_devices_type = '{device}'$,$$}
        {overdate != null && overdate != $$ &&overdate == $是$ :
        $ and f_due_date < getdate()$,$ $}
        {overdate != null && overdate != $$ && overdate == $否$ :
        $ and f_due_date > getdate()$,$ $}
    group by f_user_id
) dev on dev.f_user_id = uf.f_user_id
where info.f_user_state ='正常' and uf.f_table_state !='换表' and uf.f_user_type != '民用'
) a
where {condition}
order by alter_num desc
