select f_filiale,
       sum(filialenum) filialenum,
       sum(numday)     numday,
       sum(unnumday)   unnumday
from (
         SELECT t.f_filiale,
                isnull(filialenum, 0) filialenum,
                isnull(numday, 0)     numday,
                isnull(unnumday, 0)   unnumday
         FROM (
                  SELECT f_filiale
                  FROM t_userinfo
                  GROUP BY f_filiale
              ) t
                  LEFT JOIN (
             SELECT i.f_filiale,
                    COUNT(*) filialenum,
                    0        numday,
                    0        unnumday
             FROM t_userproperties p
                      LEFT JOIN t_userinfo i ON p.f_userinfo_id = i.f_userinfo_id
                      LEFT JOIN t_user_address a ON a.f_userinfo_id = i.f_userinfo_id
             WHERE p.f_parameter_key = 'blackList'
               AND p.f_state = '有效'
             GROUP BY i.f_filiale
             UNION ALL
             SELECT i.f_filiale,
                    0        filialenum,
                    COUNT(*) numday,
                    0        unnumday
             FROM t_userproperties p
                      LEFT JOIN t_userinfo i ON p.f_userinfo_id = i.f_userinfo_id
                      LEFT JOIN t_user_address a ON a.f_userinfo_id = i.f_userinfo_id
             WHERE p.f_parameter_key = 'blackList'
               AND p.f_state = '有效'
               AND p.f_parameter_value >= CONVERT(VARCHAR(30), getdate(), 23) + ' 00:00:00'
             GROUP BY f_filiale
             UNION ALL
             SELECT i.f_filiale,
                    0 filialenum,
                    0 numday,
                    0 unnumday
             FROM t_userproperties p
                      LEFT JOIN t_userinfo i ON p.f_userinfo_id = i.f_userinfo_id
                      LEFT JOIN t_user_address a ON a.f_userinfo_id = i.f_userinfo_id
             WHERE f_parameter_key = 'blackList'
               AND f_state = '无效'
               AND p.f_parameter_value >= CONVERT(VARCHAR(30), getdate(), 23) + ' 00:00:00'
             GROUP BY f_filiale
         ) t2 ON t.f_filiale = t2.f_filiale
         WHERE t.f_filiale != '陕西城市燃气产业发展有限公司.物联网表测试'
         and t.f_filiale != '陕西城市燃气产业发展有限公司.太平分公司') tt
GROUP BY f_filiale


