/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class imags {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static void main(String[] args) {
        String url = imags.createQrCode("https://api.piaozone.com/m5/download/img/pdffile?fileSno=1830720211104111034", "E:\\", "09952370");
        System.out.println(url);
    }

    public static String createQrCode(String url, String path, String fileName) {
        try {
            HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            BitMatrix bitMatrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, 200, 200, hints);
            File file = new File(path, fileName);
            bitMatrix = imags.deleteWhite(bitMatrix);
            if (file.exists() || (file.getParentFile().exists() || file.getParentFile().mkdirs()) && file.createNewFile()) {
                imags.writeToFile(bitMatrix, "jpg", file);
                System.out.println("\u641e\u5b9a\uff1a" + file);
                return file.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2];
        int resHeight = rec[3];
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    static void writeToFile(BitMatrix matrix, String format, File file) throws IOException {
        BufferedImage image = imags.toBufferedImage(matrix);
        if (!ImageIO.write((RenderedImage)image, format, file)) {
            throw new IOException("Could not write an image of format " + format + " to " + file);
        }
    }

    static void writeToStream(BitMatrix matrix, String format, OutputStream stream) throws IOException {
        BufferedImage image = imags.toBufferedImage(matrix);
        if (!ImageIO.write((RenderedImage)image, format, stream)) {
            throw new IOException("Could not write an image of format " + format);
        }
    }

    private static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }
}

