/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.af.plugins.UrlTools;
import com.aote.rs.mapper.WebException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import utils.ThreadResource;

public class RestTools {
    public static String request(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base) {
        if (!path.startsWith("http")) {
            path = UrlTools.getUrl((String)path);
        }
        base.setURI(URI.create(path));
        if (value != null && !"".equals(value)) {
            StringEntity se = new StringEntity(value, StandardCharsets.UTF_8);
            base.setEntity((HttpEntity)se);
        }
        RestTools.setHeaders(headersStr, base);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)base);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            String data = response.getStatusLine().getReasonPhrase();
            return "{status: " + code + ", data: '" + data + "'}";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpEntity requestPostFile(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base) {
        if (!path.startsWith("http")) {
            path = UrlTools.getUrl((String)path);
        }
        base.setURI(URI.create(path));
        if (value != null && !"".equals(value)) {
            StringEntity se = new StringEntity(value, StandardCharsets.UTF_8);
            base.setEntity((HttpEntity)se);
        }
        RestTools.setHeaders(headersStr, base);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)base);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return response.getEntity();
            }
            throw new WebException(code, "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setHeaders(String headersStr, HttpEntityEnclosingRequestBase base) {
        String token = ThreadResource.Token.get();
        if (token != null) {
            base.setHeader("Token", token);
        }
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = headers.getString(key);
                base.setHeader(key, val);
            }
        }
    }

    public static String post(String path) {
        return RestTools.post(path, null, null);
    }

    public static String post(String path, JSONObject value) {
        return RestTools.post(path, value, null);
    }

    public static HttpEntity postHttpEntity(String path, JSONObject value) {
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        return RestTools.requestPostFile(path, value.toString(), headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String post(String path, String value) {
        JSONObject headers = new JSONObject();
        return RestTools.request(path, value, headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String postheader(String path, String value) {
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        return RestTools.request(path, value, headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String post(String path, JSONObject value, JSONObject headers) {
        if (value != null) {
            if (headers == null) {
                headers = new JSONObject();
            }
            if (!headers.has("Content-Type")) {
                headers.put("Content-Type", (Object)"application/json");
            }
            return RestTools.request(path, value.toString(), headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
        }
        if (headers == null) {
            return RestTools.request(path, "", "", (HttpEntityEnclosingRequestBase)new HttpPost());
        }
        return RestTools.request(path, "", headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String getStandardURL(String protocolType, String url, String port, String paramStr) {
        if (port == null) {
            port = "80";
        }
        url = protocolType + "://" + url + ":" + port;
        if (paramStr != null) {
            url = url + paramStr;
        }
        return url;
    }
}

