/*
 * Decompiled with CFR 0.152.
 */
package bank;

import com.af.plugins.sms.PropertiesReaderPlugin;
import com.aote.logic.LogicServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BankFileDeal {
    @Autowired
    private LogicServer logicServer;
    private String path;
    private PropertiesReaderPlugin prop = new PropertiesReaderPlugin();

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void getSource() {
        File files = new File(this.path);
        File[] file = files.listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (!file[i].isFile() || !this.isLegitimacy(file[i].getAbsolutePath())) continue;
            try {
                this.dealFile(file[i]);
                this.writeToNewPath(file[i], "bak");
                continue;
            }
            catch (Exception e) {
                this.writeToNewPath(file[i], "error");
            }
        }
    }

    private boolean isLegitimacy(String path) {
        String new_path = path.replace("\\", "/");
        String filename = new_path.split("/")[new_path.split("/").length - 1];
        return filename.startsWith("nx") || filename.startsWith("yz");
    }

    private void dealFile(File file) throws Exception {
        String str = null;
        BufferedReader bf = null;
        bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
        int i = 0;
        while ((str = bf.readLine()) != null) {
            Date trade_date = null;
            if (i == 0) {
                trade_date = this.convertToDate(str.split("\\|")[0]);
                ++i;
                continue;
            }
            JSONObject job = new JSONObject();
            String[] data = str.split("\\|");
            job.put("f_trade_date", (Object)trade_date);
            job.put("f_trade_number", (Object)data[0]);
            job.put("f_user_id", (Object)data[2]);
            job.put("f_trade_type", (Object)data[4]);
            job.put("f_total_charge", (Object)data[6]);
            job.put("f_terminal_id", (Object)data[7]);
            job.put("f_organizat_id", (Object)data[8]);
            job.put("f_bank_name", new JSONObject(PropertiesReaderPlugin.read((String)"bank.properties", (String)data[9])).get("bankname"));
            job.put("f_comtypenum", (Object)data[10]);
            this.logicServer.run("bankFileDeal", job);
        }
        bf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToNewPath(File file, String target) {
        String newpath = this.path + "\\" + target + "\\" + file.getName();
        BufferedReader read = null;
        OutputStreamWriter write = null;
        try {
            String temp;
            read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
            write = new FileWriter(new File(newpath), true);
            while ((temp = read.readLine()) != null) {
                write.write(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                read.close();
                write.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean deleteFile(File file) {
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return true;
    }

    private Date convertToDate(String str) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date date = null;
        try {
            date = sdf.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }
}

