package meter;

import com.af.plugins.DateTools;
import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

public class MeterManage {
    static Logger log = Logger.getLogger(EntityServer.class);

    public void meterJoin(SqlServer sql, EntityServer entity, JSONObject data) throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_distribution_state = '已入库',f_warehouse_id = "+f_warehouse_id+" where id in "+ids);
        log.debug("更新meterinfo成功:"+n);
        // 更新仓库库存
        n = sql.runSQL("update t_warehouse set f_warehouse_number = ISNULL(f_warehouse_number, 0)+"+rowsdata.length()+",f_notreceive_number=ISNULL(f_notreceive_number, 0)+"+rowsdata.length()+" where id = "+f_warehouse_id);
        log.debug("更新t_warehouse库存成功:"+n);
    }

    // 表具领用
    public void meterReceive(SqlServer sql, EntityServer entity, JSONObject data) throws Exception {
        JSONObject model = data.getJSONObject("model");
        JSONArray rowsdata = data.getJSONArray("rowsdata");
        // 仓库id
        int f_warehouse_id = model.getInt("f_warehouse_id");
        // 本次入库的所有表具id
        ArrayList meterinfoids = new ArrayList();
        // 加入当前时间
        String nowDate = DateTools.getNow2();
        model.put("f_operate_date",nowDate);
        log.debug("model:"+model.toString());
        // 开始保存t_meter_record
        for (Object row : rowsdata) {
            JSONObject json = (JSONObject) row;
            // 表具id
            int f_meterinfo_id = json.getInt("id");
            meterinfoids.add(f_meterinfo_id);
            model.put("f_meterinfo_id",f_meterinfo_id);
            // 莫名有个id
            model.remove("id");
            // 保存record记录
            entity.partialSave("t_meter_record",model);
        }
        log.debug("保存t_meter_record完成,共"+rowsdata.length());
        // 生成更新条件
        String ids = meterinfoids.toString().replace("[","(").replace("]",")");
        log.debug("更新meterinfo条件:"+ids);

        int n = sql.runSQL("update t_meterinfo set f_distribution_state = '已领用' where id in "+ids);
        log.debug("更新meterinfo成功:"+n);
        // 更新仓库库存
        n = sql.runSQL("update t_warehouse set f_receive_number=ISNULL(f_receive_number, 0)+"+rowsdata.length()+",f_notreceive_number=ISNULL(f_notreceive_number, 0)-"+rowsdata.length()+" where id = "+f_warehouse_id);
        log.debug("更新t_warehouse库存成功:"+n);
    }
}
