package com.aote.rs.jm.aes;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;

public class SignTempCrypt {
    private static final Logger LOGGER = Logger.getLogger(SignTempCrypt.class);
    // 加密解密工具类
    private final WXBizMsgCrypt wxBizMsgCrypt;

    /**
     * 构造方法
     * @param token  token
     * @param encodingAesKey  密钥
     * @param corpId  apid
     * @throws AesException
     */
    public SignTempCrypt(String token, String encodingAesKey, String corpId) throws AesException {
        this.wxBizMsgCrypt = new WXBizMsgCrypt(token,encodingAesKey,corpId);
    }

    /**
     * 加密数据
     * @param param
     * @param timeStamp
     * @param nonce
     * @param corpId
     * @return
     */
    public JSONObject encrypt(JSONObject param, String timeStamp,String nonce,String corpId) throws Exception {
        return wxBizMsgCrypt.EncryptMsg(param.toString(), timeStamp, nonce);
    }

    /**
     * 获取请求的 请求体
     * @param param  加密后的xml
     * @return  请求体
     * @throws ParserConfigurationException
     * @throws IOException
     * @throws SAXException
     */
    public static String getRestBody(String param,String corpId) throws Exception {
        if(StringUtils.isEmpty(param)) {
            throw new Exception("密文xml为空或者不存在");
        }
        //        String body = "<xml><ToUserName><![CDATA[corpId]]></ToUserName><Encrypt><![CDATA[reqstr]]></Encrypt><AgentID><![CDATA[218]]></AgentID></xml>";
//        body = body.replaceAll("corpId", corpId);
//        body = body.replaceAll("reqstr",encrypt);
        return toxml(param, "Encrypt");
    }

    /**
     * 获取请求头
     * @param param
     * @return
     * @throws Exception
     */
    public static JSONObject getRestHeader(String param) throws Exception {
        if(StringUtils.isEmpty(param)) {
            throw new Exception("密文xml为空或者不存在");
        }
        JSONObject resultObj = new JSONObject();
        try {
            resultObj.put("msg_signature",toxml(param,"MsgSignature"));
            resultObj.put("timestamp",toxml(param,"TimeStamp"));
            resultObj.put("nonce",toxml(param,"Nonce"));
        } catch (Exception e) {
            throw new Exception("xml解析失败",e);
        }
        return resultObj;
    }

    public static void main(String[] args) {
        JSONObject object = new JSONObject("{\"alrams\":[{\"meterId\":\"1358099\",\"meterNo\":\"1011001000001625\",\"alramType\":\"1002\",\"alramTime\":\"2021-01-05 13:14:09\"}]}");
        System.out.println(object);
    }

    /**
     * 获取将请求拼接url字符串
     * @param param
     * @return
     * @throws Exception
     */
    public String getRestHeader2(String param) throws Exception {
        if(StringUtils.isEmpty(param)) throw new Exception("密文xml为空或者不存在");
        JSONObject restHeader = getRestHeader(param);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = restHeader.keys();
        while(iterator.hasNext()){
            String key = iterator.next();
            stringBuilder.append(key);
            stringBuilder.append("=");
            stringBuilder.append(restHeader.get(key));
            if(iterator.hasNext()){
                stringBuilder.append("&");
            }
        }
        return stringBuilder.toString();
    }


    /**
     * 加密数据
     * @param respStr
     * @param sign
     * @param timeStamp
     * @param nonce
     * @return
     * @throws Exception
     */
    public JSONObject decrypt(String respStr,String sign,String timeStamp,String nonce) throws Exception {
        JSONObject resultobj;
        try {
            String sMsg = wxBizMsgCrypt.DecryptMsg(sign, timeStamp, nonce, respStr);
            LOGGER.debug("解密响应内容："+ sMsg);
            resultobj = new JSONObject(sMsg);
        } catch (AesException e) {
            throw new Exception("验证签名失败",e);
        }
        return resultobj;
    }


    /**
     * 将json拼接为xml
     * @param param
     * @return
     */
    public String JsontoXml(String param, String corpId){
        if(StringUtils.isEmpty(param)) return "";
        String sRespData = "<xml><FromUserName><![CDATA[corpId]]></FromUserName><Content><![CDATA[reqstr]]></Content><AgentID>128</AgentID></xml>";
        sRespData = sRespData.replaceAll("corpId", corpId);
        sRespData = sRespData.replaceAll("reqstr",param);
        return sRespData;
    }

    /**
     * 通过xml中的标签名获取其中text, 用户获取sign,时间戳等
     * @param param
     * @param key
     * @return
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    public static String toxml(String param,String key) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        StringReader sr = new StringReader(param);
        InputSource is = new InputSource(sr);
        Document document = db.parse(is);
        Element root= document.getDocumentElement();
        //获取生成xml中的签名
        NodeList nodelist1 = root.getElementsByTagName(key);
        return  nodelist1.item(0).getTextContent();
    }

}
