package com.aote.rs.jm;


import com.aote.rs.jm.aes.AesException;
import com.aote.rs.jm.aes.SignTempCrypt;
import com.aote.rs.jm.aes.Tools;
import com.aote.rs.jm.aes.WXBizMsgCrypt;
import org.json.JSONObject;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.StringReader;

public class Example {
    private String sToken = "QDG6eK";
    private String sCorpID = "wx5823bf96d3bd56c7";
//    private String sEncodingAESKey = "jWmYm7qr5nMoAUwZRjGtBxmz3KA1tkAj3ykkR6q2B2C";
    private String sEncodingAESKey = "ZjA4OGNjZDMxMWI3NGE5MjkzYWFhYThiYTc2ODk2ZDU";
    private String sReqTimeStamp = "1409659813";
    // String sReqNonce = HttpUtils.ParseUrl("nonce");
    private String sReqNonce = "1372623149";
    private WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);

    public Example() throws AesException {
    }

    @Test
    public  void test2() throws Exception {
		/*
		------------使用示例一：验证回调URL---------------
		*企业开启回调模式时，企业号会向验证url发送一个get请求
		假设点击验证时，企业收到类似请求：
		* GET /cgi-bin/wxpush?msg_signature=5c45ff5e21c57e6ad56bac8758b79b1d9ac89fd3&timestamp=1409659589&nonce=263014780&echostr=P9nAzCzyDtyTWESHep1vC5X9xho%2FqYX3Zpb4yKa9SKld1DsH3Iyt3tP3zNdtp%2B4RPcs8TgAE7OaBO%2BFZXvnaqQ%3D%3D
		* HTTP/1.1 Host: qy.weixin.qq.com

		接收到该请求时，企业应		1.解析出Get请求的参数，包括消息体签名(msg_signature)，时间戳(timestamp)，随机数字串(nonce)以及公众平台推送过来的随机加密字符串(echostr),
		这一步注意作URL解码。
		2.验证消息体签名的正确性
		3. 解密出echostr原文，将原文当作Get请求的response，返回给公众平台
		第2，3步可以用公众平台提供的库函数VerifyURL来实现。

		/*
		------------使用示例二：对用户回复的消息解密---------------
		用户回复消息或者点击事件响应时，企业会收到回调消息，此消息是经过公众平台加密之后的密文以post形式发送给企业，密文格式请参考官方文档
		假设企业收到公众平台的回调消息如下：
		POST /cgi-bin/wxpush? msg_signature=477715d11cdb4164915debcba66cb864d751f3e6&timestamp=1409659813&nonce=1372623149 HTTP/1.1
		Host: qy.weixin.qq.com
		Content-Length: 613
		<xml>		<ToUserName><![CDATA[wx5823bf96d3bd56c7]]></ToUserName><Encrypt><![CDATA[RypEvHKD8QQKFhvQ6QleEB4J58tiPdvo+rtK1I9qca6aM/wvqnLSV5zEPeusUiX5L5X/0lWfrf0QADHHhGd3QczcdCUpj911L3vg3W/sYYvuJTs3TUUkSUXxaccAS0qhxchrRYt66wiSpGLYL42aM6A8dTT+6k4aSknmPj48kzJs8qLjvd4Xgpue06DOdnLxAUHzM6+kDZ+HMZfJYuR+LtwGc2hgf5gsijff0ekUNXZiqATP7PF5mZxZ3Izoun1s4zG4LUMnvw2r+KqCKIw+3IQH03v+BCA9nMELNqbSf6tiWSrXJB3LAVGUcallcrw8V2t9EL4EhzJWrQUax5wLVMNS0+rUPA3k22Ncx4XXZS9o0MBH27Bo6BpNelZpS+/uh9KsNlY6bHCmJU9p8g7m3fVKn28H3KDYA5Pl/T8Z1ptDAVe0lXdQ2YoyyH2uyPIGHBZZIs2pDBS8R07+qN+E7Q==]]></Encrypt>
		<AgentID><![CDATA[218]]></AgentID>
		</xml>

		企业收到post请求之后应该		1.解析出url上的参数，包括消息体签名(msg_signature)，时间戳(timestamp)以及随机数字串(nonce)
		2.验证消息体签名的正确性。
		3.将post请求的数据进行xml解析，并将<Encrypt>标签的内容进行解密，解密出来的明文即是用户回复消息的明文，明文格式请参考官方文档
		第2，3步可以用公众平台提供的库函数DecryptMsg来实现。
		*/
        String sReqMsgSig = "f5f19544c8530685e62dd2fbdc260bcbad5a989b";
        //String sReqMsgSig = "477715d11cdb4164915debcba66cb864d751f3e6";
        // String sReqTimeStamp = HttpUtils.ParseUrl("timestamp");

        // post请求的密文数据
        // sReqData = HttpUtils.PostData();
       // String sReqData = "<xml><ToUserName><![CDATA[wx5823bf96d3bd56c7]]></ToUserName><Encrypt><![CDATA[RypEvHKD8QQKFhvQ6QleEB4J58tiPdvo+rtK1I9qca6aM/wvqnLSV5zEPeusUiX5L5X/0lWfrf0QADHHhGd3QczcdCUpj911L3vg3W/sYYvuJTs3TUUkSUXxaccAS0qhxchrRYt66wiSpGLYL42aM6A8dTT+6k4aSknmPj48kzJs8qLjvd4Xgpue06DOdnLxAUHzM6+kDZ+HMZfJYuR+LtwGc2hgf5gsijff0ekUNXZiqATP7PF5mZxZ3Izoun1s4zG4LUMnvw2r+KqCKIw+3IQH03v+BCA9nMELNqbSf6tiWSrXJB3LAVGUcallcrw8V2t9EL4EhzJWrQUax5wLVMNS0+rUPA3k22Ncx4XXZS9o0MBH27Bo6BpNelZpS+/uh9KsNlY6bHCmJU9p8g7m3fVKn28H3KDYA5Pl/T8Z1ptDAVe0lXdQ2YoyyH2uyPIGHBZZIs2pDBS8R07+qN+E7Q==]]></Encrypt><AgentID><![CDATA[218]]></AgentID></xml>";
      //  String sReqData="<xml><Encrypt><![CDATA[JOgTr2vkKsOBXUq2aXDlK17zRLoCH1z1yzlGW0/qaskJi5OXPdX8rETa23sOSeT96ZI3F8XxaZJMKWVcM+LzxdDfTjsuTv9N5Up617j4z4YX6nlgGFq1666kFaj7k6HMLRF6ImN2NZ5gi3+OMZ1E4cG/sah95KnUumrPj9EfQ9vEUsc2cgSSys11UsvjRhsCtZYrALct9L5MjaAfVbSDY4Ev6cOwg8JHHjAbgouUcgSmunZOswHCsk0IYUL5ioEgbNUHgquzQ4zhVwpv+UpA4KRrfHGErxr14G5p3XVFHyTSgQZAu/NjNpal/qLR2hs1yNsOEMr6OvLwl0gmoSn2zg==]]></Encrypt><MsgSignature><![CDATA[02f2cf163ebd7c7996704c34c7151f084dc63d5b]]></MsgSignature><TimeStamp>1409659813</TimeStamp><Nonce><![CDATA[1372623149]]></Nonce></xml>";
        String sReqData = "<xml>\n" +
                "<Encrypt><![CDATA[Q21cLVx75l0EUMQvH4n6mciEJFQlsynY97HnOsqdYm0/iMYke+m+0D/x2UMbI5qu1uk41LIhzIeF8XlW7cgxHGhMrsY42WbDlOT5irEdUyf8SpCC/30gZpZ3lrQMhNYwBVkR+A54+cvvUrqVNhQU+1+sK8Ob4FlNn5NkIPr0Qf6PdTgf+xcKmdq1Gcw/kko23tm4s9chLyqNCDQwAOMd79vqCbpZ2Zh7uxTyYxtTWijLzx8LL0civjHt1moaSQ3o6jp5httVOTdTk/y4fqVgLPbwYuWAud6FzNBgy5IlKwAuhc+9NFmYZHITCZ2hdIiZmsR8Hz3X5fbfvXNJFGBHpw==]]></Encrypt>\n" +
                "<MsgSignature><![CDATA[f5f19544c8530685e62dd2fbdc260bcbad5a989b]]></MsgSignature>\n" +
                "<TimeStamp>1409659813</TimeStamp>\n" +
                "<Nonce><![CDATA[1372623149]]></Nonce>\n" +
                "</xml>";
        try {
            String sMsg = wxcpt.DecryptMsg(sReqMsgSig, sReqTimeStamp, sReqNonce, sReqData);
            System.out.println("after decrypt msg: " + sMsg);
            // TODO: 解析出明文xml标签的内容进行处理
            // For example:
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader sr = new StringReader(sMsg);
            InputSource is = new InputSource(sr);
            Document document = db.parse(is);

            Element root = document.getDocumentElement();
            NodeList nodelist1 = root.getElementsByTagName("Content");
            String Content = nodelist1.item(0).getTextContent();
            System.out.println("Content：" + Content);

        } catch (Exception e) {
            // TODO
            // 解密失败，失败原因请查看异常
            e.printStackTrace();
        }

	/*
		------------使用示例三：企业回复用户消息的加密---------------
		企业被动回复用户的消息也需要进行加密，并且拼接成密文格式的xml串。
		假设企业需要回复用户的明文如下：
		<xml>
		<ToUserName><![CDATA[mycreate]]></ToUserName>
		<FromUserName><![CDATA[wx5823bf96d3bd56c7]]></FromUserName>
		<CreateTime>1348831860</CreateTime>
		<MsgType><![CDATA[text]]></MsgType>
		<Content><![CDATA[this is a test]]></Content>
		<MsgId>1234567890123456</MsgId>
		<AgentID>128</AgentID>
		</xml>

		为了将此段明文回复给用户，企业应：			1.自己生成时间时间戳(timestamp),随机数字串(nonce)以便生成消息体签名，也可以直接用从公众平台的post url上解析出的对应值。
		2.将明文加密得到密文。	3.用密文，步骤1生成的timestamp,nonce和企业在公众平台设定的token生成消息体签名。			4.将密文，消息体签名，时间戳，随机数字串拼接成xml格式的字符串，发送给企业。
		以上2，3，4步可以用公众平台提供的库函数EncryptMsg来实现。
		*/


    }
//
//    @Test
//    public void  vierf(){
//
//        String sRespData = "<xml><ToUserName><![CDATA[mycreate]]></ToUserName><FromUserName><![CDATA[wx5823bf96d3bd56c7]]></FromUserName><CreateTime>1348831860</CreateTime><MsgType><![CDATA[text]]></MsgType><Content><![CDATA[this is a test]]></Content><MsgId>1234567890123456</MsgId><AgentID>128</AgentID></xml>";
//       try{
//            String sEncryptMsg = wxcpt.EncryptMsg(sRespData, sReqTimeStamp, sReqNonce);
//            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
//            DocumentBuilder db = dbf.newDocumentBuilder();
//            StringReader sr = new StringReader(sEncryptMsg);
//            InputSource is = new InputSource(sr);
//            Document document = db.parse(is);
//
//            Element root = document.getDocumentElement();
//            NodeList nodelist1 = root.getElementsByTagName("MsgSignature");
//            String MsgSignature = nodelist1.item(0).getTextContent();
//            System.out.println(MsgSignature);
//            NodeList nodelist2 = root.getElementsByTagName("TimeStamp");
//            String TimeStamp = nodelist2.item(0).getTextContent();
//            System.out.println(TimeStamp);
//            NodeList nodelist3 = root.getElementsByTagName("Nonce");
//            String Nonce = nodelist3.item(0).getTextContent();
//            System.out.println(Nonce);
//            System.out.println("after encrypt sEncrytMsg: " + sEncryptMsg);
//            // 加密成功
//            // TODO:
//            // HttpUtils.SetResponse(sEncryptMsg);
//        }
//        catch(Exception e)
//        {
//            e.printStackTrace();
//            // 加密失败
//        }
//    }
//
   @Test
   public void ttest() throws Exception {
        String sToken = "QDG6eK";
        String sCorpID = "wx5823bf96d3bd56c7";
        String sEncodingAESKey = "ZjA4OGNjZDMxMWI3NGE5MjkzYWFhYThiYTc2ODk2ZDU";
        String sReqTimeStamp = "1409659813";
        String sReqNonce = "1372623149";
       SignTempCrypt signTempCrypt = new SignTempCrypt(sToken,sEncodingAESKey,sCorpID);
       JSONObject jsonObject = new JSONObject("{\"data\":{\"f_userinfo_id\":2778,\"f_serial_number\":\"\",\"f_balance\":13,\"f_overdue\":0,\"f_collection\":12,\"f_preamount\":0,\"f_payment\":\"现金缴费\",\"f_print\":\"普通收据\",\"f_privilege_money\":0,\"f_after_discount\":\"12\",\"isBreakOverdue\":false,\"floor\":false,\"operInfo\":{\"f_operator\":\"admin\",\"f_operatorid\":\"240728\",\"f_orgid\":\"453\",\"f_orgname\":\"临沂公司\",\"f_depid\":\"1561\",\"f_depname\":\"河东营业厅\"},\"other\":{\"f_collection\":0,\"f_payment\":\"现金缴费\",\"f_voucher_number\":\"\",\"f_print\":\"普通收据\",\"f_service_person\":\"admin\",\"t_userfees\":\"\",\"f_fee_type\":[\"0\"],\"f_fee_time\":[\"12\"],\"otherdetail\":[{\"f_brand_spec\":[\"生活垃圾\"],\"f_unitprice\":\"5\",\"f_number\":0}]}}}");
       System.out.println("加密前数据:"+jsonObject.toString());
       //jsonObject.put("name", "xiaomign");
       //加密
       JSONObject encrypt = Tools.encrypt(jsonObject);
       System.out.println("加密后数据:"+encrypt);
       //通过加密数据获得请求头
       //JSONObject restHeader = signTempCrypt.getRestHeader(encrypt);
      // String restHeader2 = signTempCrypt.getRestHeader2(encrypt);
       System.out.println("请求头2:"+encrypt.get("header"));
       System.out.println("请求体:"+encrypt.get("content"));
       //通过加密数据获得请求体
      // String restBody = signTempCrypt.getRestBody(encrypt);
       //解密
      // String jmbody = signTempCrypt.pjbody(restBody);
      // System.out.println("xxx: "+jmbody);
      // JSONObject decrypt = signTempCrypt.decrypt(jmbody, (String)restHeader.get("msg_signature"), sReqTimeStamp, sReqNonce);
      // System.out.println("解密后:"+decrypt);
   }

}
