package com.aote.handler;


import com.aote.rs.jm.aes.Tools;
import com.aote.rs.plugins.ParameterRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InterFaceFiliterSign implements Filter {
    static Logger log = Logger.getLogger(InterFaceFiliterSign.class);
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("进入accesstoken,签名验证拦截器");
        HttpServletRequest httpServletRequest =(HttpServletRequest) request;
        HttpServletResponse httpServletResponse = (HttpServletResponse) response;
        //获取请求头
        String msg_signature = httpServletRequest.getHeader("msg_signature");
        String timestamp = httpServletRequest.getHeader("timestamp");
        String nonce = httpServletRequest.getHeader("nonce");
        if (StringUtils.isEmpty(msg_signature) || StringUtils.isEmpty(timestamp)|| StringUtils.isEmpty(nonce)) {
            resultError(701,"not accesskey or sign was found", httpServletResponse);
            return;
        }
        //拼接请求头
        JSONObject requestHeader = new JSONObject();
        requestHeader.put("msg_signature",msg_signature);
        requestHeader.put("timestamp",timestamp);
        requestHeader.put("nonce",nonce);
        //获取请求体
        String postData = getPostData(httpServletRequest);
        JSONObject requestvalue = new JSONObject();
        try {
            requestvalue = Tools.decrypt(postData, requestHeader);
        } catch (Exception e) {
            resultError(402,"Illegal access, signature verification failed", httpServletResponse);
            return;
        }
        if(requestvalue.length()>0){
            ParameterRequestWrapper requestWrapper = new ParameterRequestWrapper((HttpServletRequest)request);
            Iterator<String> it = requestvalue.keys();
            System.out.println(requestvalue);
            while(it.hasNext()){
                String key = it.next();
                requestWrapper.addParameter(key,requestvalue.get(key));
            }
            log.debug("进入chain.doFilter");
            chain.doFilter(requestWrapper, response);
            log.debug("出入chain.doFilter");
        }else{
            resultError(502,"Server error", httpServletResponse);
            return;

        }
        //验签通过

        try {

        } catch (Exception e) {
            e.printStackTrace();
            resultError(502,"Server error", httpServletResponse);
            return;
        }

    }

    @Override
    public void destroy() {

    }
    // 返回错误提示
    public void resultError(Integer code,String errorMsg, HttpServletResponse httpServletResponse) throws IOException {
        JSONObject resultJson = new JSONObject();
        resultJson.put("code",code);
        resultJson.put("msg",new String(errorMsg.getBytes("UTF-8")));
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(new String(resultJson.toString().getBytes("UTF-8")));
    }

    private  String getPostData(HttpServletRequest request) {
        StringBuffer data = new StringBuffer();
        String line = null;
        BufferedReader reader = null;
        try {
            reader = request.getReader();
            while (null != (line = reader.readLine()))
                data.append(line);
        } catch (IOException e) {
        } finally {
        }
        return data.toString();
    }

}
