package com.af.timejob;

import com.aote.rs.LogicService;
import file.ReadFile;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Lazy(false)
public class MasterOrganization {

    static Logger log = Logger.getLogger(LogicService.class);

    @Autowired
    private LogicService logicService;

    @Scheduled(cron = "0 0 23 * * ?") //每天23点
    public void doJob(){
        log.debug("进入了定时器执行定时任务:增量获取组织");
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        log.debug("获取到的执行配置为---》"+conf.get("masterOrganizationincrement"));
        if ((boolean) conf.get("masterOrganizationincrement")){
            try {
                log.debug("开始增量获取组织");
                logicService.xtSave("masterOrganizationincrement", new JSONObject().put("data", new JSONObject().toString()).toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("未配置启动自动下发");
        }
    }

}

