package com.aote.util;

import com.aote.job.InformJob;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;

public class HttpUtil {

    private static final Logger log = Logger.getLogger(InformJob.class);

    /**
     *
     * @param url 传入的get方式的url，传值为&拼接
     * @return 接口返回结果
     */
    public String doGet(String url) {
        log.error("接口url:::::::::::::::"+url);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        URIBuilder uriBuilder = null;
        String data = "";
        try {
            uriBuilder = new URIBuilder(url);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            CloseableHttpResponse httpResponse = httpClient.execute(httpGet);
            HttpEntity entity = httpResponse.getEntity();
            data = EntityUtils.toString(entity);
            log.error("接口请求返回结果:::::::::::::::"+data);
        } catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        } finally {
            if (uriBuilder != null) {
                uriBuilder.clearParameters();
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return data;
    }


    /**
     *
     * @param httpUrl post方式的url
     * @param param 传入的参数：jsonObj对象的toString
     * @return 调用返回结果
     */
    public String doPost(String httpUrl, String param) {
        StringBuffer result = new StringBuffer();
        HttpURLConnection connection = null;
        OutputStream os = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            if (param != null && !"".equals(param)) {
                os = connection.getOutputStream();
                os.write(param.getBytes("UTF-8"));
            }
            log.error("接口返回值");
            log.error(connection.getResponseMessage());
            log.error(connection.toString());
            if (connection.getResponseCode() == 200) {
                is = connection.getInputStream();
                if (is != null) {
                    br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String temp = null;
                    if ((temp = br.readLine()) != null) {
                        result.append(temp);
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            assert connection != null;
            connection.disconnect();
        }
        return result.toString();
    }


}
