package com.aote.timer;

import com.aote.rs.LogicService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDate;
import java.time.Month;

public class HLClearMonthPlanTimer {

    @Autowired
    private LogicService logicService;

    private static Logger log = Logger.getLogger(HLClearMonthPlanTimer.class);

    public void clearMonthPlan() throws Exception {
        //工商业安检（民生，海乐）
        // 需要调整为4个月循环安检一次。每年一月开始从新按照规则生效
        log.debug("clearMonthPlan");
        LocalDate currentDate = LocalDate.now();
        Month currentMonth = currentDate.getMonth();
        // 判断当前月份是否是1月、5月或9月
        if (currentMonth == Month.JANUARY || currentMonth == Month.MAY || currentMonth == Month.SEPTEMBER) {
            log.debug("海乐"+currentMonth.getValue());
            logicService.xtSave("clearPlanId", "{data:{month: " + currentMonth.getValue() + "}}");
        } else {
            log.debug("当前月份不是1月、5月或9月，不执行清除操作");
        }
    }
}
