package com.aote.rs;

import com.aote.redis.RedisUtil;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.inject.Singleton;
import javax.ws.rs.*;
import java.util.Map;

@Path("safePosition")
@Singleton
@Component
public class SavePsoitionService {
    private static Logger log = Logger.getLogger(ServicePlugin.class);
    @Autowired
    private SqlServer sqlServer;

    private RedisUtil redisutl = RedisUtil.getInstance();

    /**
     * 保存安检员实时位置信息
     *
     * @param value {l:114.025655,b:35.66,t:'2021-01-01 12:23:55',name:'何文强'}
     * @return 结果
     * @throws Exception
     */
    @POST
    @Path("savePosition")
    public String saveVueConfig(String value) {
        log.debug("进行安检员点位存储:"+value+"--");
        JSONObject position=new JSONObject(value);
        // restfull版本到50版本后 底层方法参数位置被改了。
        redisutl.setHashKey("safe_position",position.get("userid").toString(),position.toString());
        log.debug("111111111------------"+redisutl.getHash("safe_position").toString());
        return "200";
    }

    @GET
    @Path("getPosition")
    public String getPosition() {
        log.debug("----------------进入getPosition");
        Map<Object, Object> obj = redisutl.getHash("safe_position");
        //log.debug("----------------获取到的json--"+obj.toString());
        return obj.toString();
    }

}
