package com.aote.rs;

import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

@Path("newReport")
@Component
public class ReportNew {

    @Autowired
    private LogicService logicService;
    private Logger log = Logger.getLogger(ReportNew.class);
    @POST
    @Path("/getData")
    @Transactional
    /*
     * 获取报表数据的接口，此接口的传参方式必须为restful风格
     * 接口返回值必须为com.alibaba.fastjson.JSONObject,并且内容必须拿data包裹起来
     * request：前端拼接在url后面的参数列表
     */
    public String getReportData(
            @Context HttpServletRequest request) throws Exception {
        try{
            Map<String,String[]> map = request.getParameterMap();
            JSONObject jsonObject = new JSONObject();
            for(Map.Entry<String, String[]> entry : map.entrySet()){

                // 解码
                jsonObject.put(entry.getKey(),URLDecoder.decode(entry.getValue()[0]));
            }
            String logicName = jsonObject.getString("logicName");
            List<Object> reportData =  new JSONArray(
                    logicService.xtSave(logicName,jsonObject.toString())).toList();
            com.alibaba.fastjson.JSONObject apiResult = new com.alibaba.fastjson.JSONObject();
            apiResult.put("data",reportData);
            log.debug("报表测试==>"+apiResult);
            return apiResult.toJSONString();
        } catch (Exception exception) {
            log.error(exception);
            throw new Exception();
        }
    }
}
