package com.aote.plugins.map;

import com.af.plugins.Base64Utils;
import com.af.plugins.DateTools;
import com.aote.module.ModuleMapper;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;


public class PhoneStateController {

    static Logger log = Logger.getLogger(PhoneStateController.class);

    @Autowired
    private SqlServer sqlServer;

    /**
     * @param "需要保存的手机状态数据"
     * @return "返回状态码"
     * @savePhoneState "保存手机状态"
     **/
    public String savePhoneState(JSONObject jsonObject) throws Exception {
        System.out.println("需要保存的点位集为 --------------- ");
        System.out.println(jsonObject);
        //  将穿过来的字符串转换为 JSONObject
        JSONArray position = new JSONArray(jsonObject.get("locations").toString());
        //  封装需要保存的数据
        JSONArray params = new JSONArray();
        StringBuilder sql = new StringBuilder("INSERT INTO t_phone_state(f_user_id, f_user_name, f_longitude, f_latitude, f_realtime, f_datetime, f_speed, f_bearing, f_up_time) VALUES ");
        for (Object o : position) {
            JSONObject p = new JSONObject(o.toString());
            p.put("f_up_time", DateTools.getNow2());
            p.put("f_datetime", this.convertToSeconds(p.get("f_realtime").toString()));
            params.put(p);
            sql.append(paramsUtil(p));
        }
        //  去掉最后一个,
        String s = sql.append(";").toString().replace(",;", "");
        System.out.println("-------------------添加sql已生成---------------------");
        System.out.println(s);
        return s;
    }

    //  获取时间戳的方法
    public String convertToSeconds(String timeString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.parse(timeString, formatter);
        return dateTime.toEpochSecond(ZoneOffset.UTC) + "";
    }

    //  拼接需要保存的参数
    public String paramsUtil(JSONObject one) {
        String f_user_id = one.getString("f_user_id");
        String f_user_name = one.getString("f_user_name");
        String f_longitude = one.getString("f_longitude");
        String f_latitude = one.getString("f_latitude");
        String f_realtime = one.getString("f_realtime");
        String f_datetime = one.getString("f_datetime");
        String f_speed = one.getString("f_speed");
        String f_bearing = one.getString("f_bearing");
        String f_up_time = one.getString("f_up_time");
        return "('" + f_user_id + "', '" + f_user_name + "', '" + f_longitude + "', '" + f_latitude + "', '" + f_realtime + "', '" + f_datetime + "', '" + f_speed + "', '" + f_bearing + "', '" + f_up_time + "' ),";
    }

    //  获取文件上传的前路径
    public String getFileUploadPath() {
        log.debug("获取module.xml中配置的文件上传路径");
        return ModuleMapper.getAttr("safecheck", "upload");
    }

    public String saveFile(String data, String filename) {
        String savePath = getFileUploadPath();
        log.debug("文件上传的路径为 >>>>> " + savePath);
        File dir = new File(savePath + File.separator + DateTools.getNow("yyyy-MM-dd"));
        FileOutputStream fop = null;
        File file = null;
        if (!dir.exists()) {
            final boolean mkdir = dir.mkdirs();
            log.debug("文件夹创建结果:::" + mkdir);
            if (!mkdir){
                throw new RuntimeException("文件夹创建失败") ;
            }
        }
        try {
            file = new File(dir.getAbsolutePath() + File.separator + DateTools.getNow("yyyy_MM_dd_hh_mm_ss") + filename);
            fop = new FileOutputStream(file);
            byte[] content = Base64Utils.decodeBuffer(data.split(",")[1]);
            fop.write(content);
            fop.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return file.getAbsolutePath();
    }

}
