package com.aote.plugins.jsondispose;

import com.aote.ThreadResource;
import com.aote.rs.mapper.WebException;

import java.io.*;
import java.nio.charset.StandardCharsets;

public class JsonChange {

  public static void jsonSet(String jsonStr, String vueName) {
    String dir = ThreadResource.ComponentDir.get();
    if (dir == null) {
      // 把文件不存在异常转换成704错误状态
      throw new WebException(704, "用户没有特殊目录！");
    }
    String path =
        Thread.currentThread().getContextClassLoader().getResource("/").getPath()
            + dir
            + "/phonevues/"
            + vueName;
    System.out.println(jsonStr);
    String jsonStr_format = format(jsonStr);
    File file = new File(path);
    PrintWriter pw = null;
    try {
      pw =
          new PrintWriter(
              new OutputStreamWriter(new FileOutputStream(file), StandardCharsets.UTF_8));
      pw.println(jsonStr_format);
    } catch (IOException e) {
      e.printStackTrace();
    } finally {
      if (pw != null) {
        pw.flush();
        pw.close();
      }
    }
  }

  public static String format(String jsonStr) {
    try {
      ByteArrayInputStream in = new ByteArrayInputStream(jsonStr.getBytes());
      ByteArrayOutputStream out = new ByteArrayOutputStream();
      char ch;
      int read;
      int space = 0;
      while ((read = in.read()) > 0) {
        ch = (char) read;
        switch (ch) {
          case '{':
            {
              space = outputAndRightMove(space, ch, out);
              break;
            }
          case '[':
            {
              out.write(ch);
              space += 2;
              break;
            }
          case '}':
          case ']':
            {
              space = outputAndLeftMove(space, ch, out);
              break;
            }
          case ',':
            {
              out.write(ch);
              outputNewline(out);
              out.write(getBlankingStringBytes(space));
              break;
            }
          default:
            {
              out.write(ch);
              break;
            }
        }
      }
      return out.toString();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }

  public static int outputAndRightMove(int space, char ch, ByteArrayOutputStream out)
      throws IOException {
    // 换行
    outputNewline(out);
    // 向右缩进
    out.write(getBlankingStringBytes(space));
    out.write(ch);
    outputNewline(out);
    space += 2;
    // 再向右缩进多两个字符
    out.write(getBlankingStringBytes(space));
    return space;
  }

  public static int outputAndLeftMove(int space, char ch, ByteArrayOutputStream out)
      throws IOException {
    outputNewline(out);
    space -= 2;
    out.write(getBlankingStringBytes(space));
    out.write(ch);
    return space;
  }

  public static byte[] getBlankingStringBytes(int space) {
    StringBuilder sb = new StringBuilder("");
    for (int i = 0; i < space; i++) {
      sb.append(" ");
    }
    return sb.toString().getBytes();
  }

  public static void outputNewline(ByteArrayOutputStream out) {
    out.write('\n');
  }
}
