package com.aote.job;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.util.HashMap;

public class InformJob {
	private static Logger log = Logger.getLogger(InformJob.class);

	/**
	 * 定时全局提醒逻辑模块名
	 */
	private String bzLogic;
	/**
	 * 添加定时提醒项
	 */
	private String addNotifierUrl;
	/**
	 * 更新定时提取项
	 */
	private String updateNotifierUrl;
	/**
	 * 移除定时提取项
	 */
	private String removeNotifierUrl;
	/**
	 * 呼叫系统url
	 */
	private String ccurl;

	/**
	 * 代办活动
	 */
	private HashMap<String, String> activities;

	/**
	 * 活动对应的页面url
	 */
	private HashMap<String, String> urls;

	/**
	 * 跨域真正的url
	 */
	private HashMap<String, String> corUrls;

	/**
	 * 模块名字, tab上的名字
	 */
	private HashMap<String, String> modules;

	public void run() throws Exception{
		log.debug("inform job is running......");
		JSONObject jo = new JSONObject();
		jo.put("addNotifierUrl", addNotifierUrl);
		jo.put("updateNotifierUrl", updateNotifierUrl);
		jo.put("removeNotifierUrl", removeNotifierUrl);
		jo.put("activities", activities);
		jo.put("urls", urls);
		jo.put("corUrls", corUrls);
		jo.put("modules", modules);
		runlogic(ccurl, bzLogic, jo);
	}

	private String runlogic(String url, String logic, JSONObject params) throws Exception {
		String path= url + "rs/logic/" + logic;
		String body = "{\"data\":" + params + "}";
		// POSTMethod
		HttpPost postMethod =new HttpPost(path);
		StringEntity se = new StringEntity(body, "UTF-8");
		postMethod.setEntity(se);
		// 发送Post请求
		HttpClient httpClient = new DefaultHttpClient();
		HttpResponse response = httpClient.execute(postMethod);
		int code = response.getStatusLine().getStatusCode();
		// 如果不成功
		if (code != 200) {
			throw new RuntimeException("返回值错误：" + code);
		} else
            return EntityUtils.toString(response.getEntity(), "UTF8");
	}


	public String getBzLogic() {
		return bzLogic;
	}

	public void setBzLogic(String bzLogic) {
		this.bzLogic = bzLogic;
	}

	public String getAddNotifierUrl() {
		return addNotifierUrl;
	}

	public void setAddNotifierUrl(String addNotifierUrl) {
		this.addNotifierUrl = addNotifierUrl;
	}

	public String getUpdateNotifierUrl() {
		return updateNotifierUrl;
	}

	public void setUpdateNotifierUrl(String updateNotifierUrl) {
		this.updateNotifierUrl = updateNotifierUrl;
	}

	public String getRemoveNotifierUrl() {
		return removeNotifierUrl;
	}

	public void setRemoveNotifierUrl(String removeNotifierUrl) {
		this.removeNotifierUrl = removeNotifierUrl;
	}

	public String getCcurl() {
		return ccurl;
	}

	public void setCcurl(String ccurl) {
		this.ccurl = ccurl;
	}

	public HashMap<String, String> getActivities() {
		return activities;
	}

	public void setActivities(HashMap<String, String> activities) {
		this.activities = activities;
	}

	public HashMap<String, String> getUrls() {
		return urls;
	}

	public void setUrls(HashMap<String, String> urls) {
		this.urls = urls;
	}

	public HashMap<String, String> getCorUrls() {
		return corUrls;
	}

	public void setCorUrls(HashMap<String, String> corUrls) {
		this.corUrls = corUrls;
	}

	public HashMap<String, String> getModules() {
		return modules;
	}

	public void setModules(HashMap<String, String> modules) {
		this.modules = modules;
	}

}
