
SELECT
    f_order_man,
    COUNT ( 0 ) AS telcount,
    SUM ( aa ) AS wccount,
    CAST(CAST(SUM ( aa )*100/COUNT ( 0 ) as decimal(10,2)) as varchar(50)) +'%' as wclv,
    SUM (bb) AS pjtime,
    SUM(cc) AS cstime
FROM
    (
        SELECT
            swo.f_order_man,

            CASE
                WHEN f_result_status = '已完成' THEN
                    1 ELSE 0
                END AS aa,

            CASE
                WHEN f_date is not NULL THEN
                    DATEDIFF(HOUR, f_created_date, f_date)  ELSE 0
                END AS bb,

            CASE
                WHEN f_date IS NOT NULL THEN
                    CASE
                        WHEN DATEDIFF(HOUR, f_created_date, f_date) >= {substitutionOverdue} THEN
                            DATEDIFF(HOUR, f_created_date, f_date)
                        ELSE
                            0
                        END
                ELSE
                    0
                END AS cc
        FROM
            t_serviceworkorder swo
                LEFT JOIN t_servicework sw ON swo.id= sw.serviceid
        WHERE
                swo.f_workorder_type= '置换通气单'  and isnull(swo.f_state,'正常') != '撤销'
                and {condition} and swo.f_filiale_id in {f_filiale_id}
    ) tt
GROUP BY
    tt.f_order_man
