SELECT
    t0.f_plan_month,
    t0.zongliang,
    isnull( t1.rh, 0 ) rh,
    isnull( t1.dfby, 0 ) dfby,
    isnull( t1.wsy, 0 ) wsy,
    isnull( t1.jj, 0 ) jj
FROM
    (
        SELECT MONTH
            ( cpi.f_open_date ) f_plan_month,
            COUNT ( 0 ) zongliang,
            0 yijian
        FROM
            t_userinfo cpi
        WHERE
            ( cpi.f_user_state= '正常' OR cpi.f_user_state= '停用' ) { orgid != $$ :
            $
          AND cpi.f_filialeid IN { orgid } $,
            $ $
            }
          AND cpi.f_open_date < CAST (
            { year } AS VARCHAR ( 4 )) + '-01-01'
        GROUP BY
            MONTH ( cpi.f_open_date )) t0
        LEFT JOIN (
        SELECT
            f_plan_month,
            isnull(入户, 0 ) rh,
            isnull(到访不遇, 0 ) dfby,
            isnull(未使用天然气, 0 ) wsy,
            isnull(拒检, 0 ) jj
        FROM
            (
                SELECT CAST
                           ( SUBSTRING ( u2.f_offsite_time, 6, 2 ) AS INT ) f_plan_month,
                       u2.f_entry_status,
                       COUNT ( DISTINCT u2.f_userinfoid ) counts
                FROM
                    t_check_plan_item u1
                        LEFT JOIN t_check_paper u2 ON u1.id= u2.f_check_item_id
                        LEFT JOIN t_check_plan u3 ON u3.id= u1.f_plan_id
                WHERE
                        f_offsite_time = ( SELECT MAX ( f_offsite_time ) FROM t_check_paper cp2 WHERE u2.f_userinfoid= cp2.f_userinfoid )
                  AND u2.f_check_type = '民用' { orgid != $$ :
			$
			AND u1.f_filialeid IN { orgid } $,
			$ $
			}
			{ f_safecheck_type != $$ :
			$
			AND u1.f_safecheck_type = '{ f_safecheck_type }' $,
			$ $
			}
			AND u3.f_plan_year = { year }
			{ plan_type == $ FALSE $ :
			$
			AND u2.f_safe_type IS NULL $,
			plan_type == $ TRUE $ :
			$
			AND u2.f_safe_type = '{plan_type}' $,
			plan_type == $$ :
			$
			AND 1 = 1 $,
			$$
			}
                GROUP BY
                    CAST ( SUBSTRING ( u2.f_offsite_time, 6, 2 ) AS INT ),
                    u2.f_entry_status
            ) AS P PIVOT ( SUM ( counts ) FOR p.f_entry_status IN ( [入户], [到访不遇], [未使用天然气], [拒检] ) ) AS T
    ) t1 ON t0.f_plan_month = t1.f_plan_month
ORDER BY
    f_plan_month
