select
    f_residential_area,
    sum(month1) month1,
    sum(month2) month2,
    sum(month3) month3,
    sum(month4) month4,
    sum(month5) month5,
    sum(month6) month6,
    sum(month7) month7,
    sum(month8) month8,
    sum(month9) month9,
    sum(month10) month10,
    sum(month11) month11,
    sum(month12) month12,
    count (0) as countarea
from (
      SELECT
          case when tcp.f_safecheck_type = '申请安检' then '申请安检' else tcpi.f_residential_area end as f_residential_area,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 1 THEN 1 ELSE 0 END as month1,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 2 THEN 1 ELSE 0 END as month2,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 3 THEN 1 ELSE 0 END as month3,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 4 THEN 1 ELSE 0 END as month4,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 5 THEN 1 ELSE 0 END as month5,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 6 THEN 1 ELSE 0 END as month6,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 7 THEN 1 ELSE 0 END as month7,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 8 THEN 1 ELSE 0 END as month8,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 9 THEN 1 ELSE 0 END as month9,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 10 THEN 1 ELSE 0 END as month10,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 11 THEN 1 ELSE 0 END as month11,
          CASE WHEN MONTH(tcpi.f_last_check_date) = 12 THEN 1 ELSE 0 END as month12
      FROM
          t_check_plan_item tcpi
              LEFT JOIN t_check_plan tcp ON tcpi.f_plan_id = tcp.id
      WHERE {condition} and tcpi.f_filialeid = {orgid} and (tcpi.f_last_check_state = '入户' or (tcpi.f_last_check_state = '到访不遇' and tcpi.f_check_version >=3))
    ) t
GROUP BY
    f_residential_area
order by case when f_residential_area = '申请安检' then 1 else 0 end

