SELECT
    tcpi.f_residential_area,
    count(tcpi.id) as totalcount,
    SUM(CASE WHEN tcpi.f_state = '未检' and tcpi.f_last_check_state is null THEN 1 ELSE 0 END) AS wjcount,
    SUM(CASE WHEN tcp.f_safecheck_type = '申请安检' THEN 1 ELSE 0 END) AS sqajcount,
    SUM(CASE WHEN tcp.f_safecheck_type != '申请安检' and (tcpi.f_last_check_state in ('入户') OR (tcpi.f_last_check_state = '到访不遇' and tcpi.f_check_version >= 3)) THEN 1 ELSE 0 END) AS yjcount,
    SUM(CASE WHEN (tcp.f_safecheck_type != '申请安检' and (tcpi.f_last_check_state in ('入户') OR (tcpi.f_last_check_state = '到访不遇' and tcpi.f_check_version >= 3))) or tcp.f_safecheck_type = '申请安检' THEN 1 ELSE 0 END) AS ruhucount,
    SUM(CASE WHEN tcpi.f_last_check_state = '入户' THEN 1 ELSE 0 END) AS rhcount,
    SUM(CASE WHEN tcpi.f_check_version = 1 and tcpi.f_last_check_state = '到访不遇' THEN 1 ELSE 0 END) AS dfbycount1,
    SUM(CASE WHEN tcpi.f_check_version = 2 and tcpi.f_last_check_state = '到访不遇' THEN 1 ELSE 0 END) AS dfbycount2,
    SUM(CASE WHEN tcpi.f_check_version >= 3 and tcpi.f_last_check_state = '到访不遇' THEN 1 ELSE 0 END) AS dfbycount3,
    sum(case when tcpi.f_last_check_state = '到访不遇' THEN 1 ELSE 0 END) AS unique_dfby_count,
    SUM(CASE WHEN tcpi.f_last_check_state = '拒检' THEN 1 ELSE 0 END) AS jjcount,
    case when COUNT(0) = 0 then '0.00%' else
            CONVERT(varchar,CONVERT(decimal(10, 2), ((SUM(CASE WHEN tcpi.f_last_check_state = '入户' OR tcpi.f_check_version = 3 THEN 1 ELSE 0 END) * 100.0) / NULLIF(COUNT(*), 0))))+ '%' end AS check_bv
FROM
    t_check_plan_item tcpi
        LEFT JOIN t_check_plan tcp ON tcpi.f_plan_id = tcp.id
WHERE {condition} and tcpi.f_filialeid = {orgid}
GROUP BY
    tcpi.f_residential_area
