SELECT
    *
FROM
    (
        SELECT
            tcp.f_userinfoid f_userinfo_id,
            tcp.f_user_name,
            tcp.f_user_phone,
            tcp.f_residential_area,
            tcp.f_address,
            tcp.f_checker_name,
            tcp.f_offsite_time,
            tcp.f_filialeid,
            tpd.f_device_type,
            tdi.f_item_name,
            tdi.f_item_value,
            tdi.f_path,
            tdi.f_p1_path,
            tdi.f_p2_path,
            tdi.f_deal_dispose,
            tdi.f_longitude,
            tdi.f_latitude,
            tcp.f_upload_date,
            tcp.f_check_type,
            tcp.id as f_paper_id,
            tdi.id as f_defect_id,
            tdi.f_repair_path,
            tdi.f_repair1_path,
            tdi.f_repair2_path,
            tdi.f_defect_level,
            CASE when tdi.f_is_repaired is null then '未处理' else tdi.f_is_repaired end as f_is_repaired,
            tdi.f_repairman,
            tdi.f_repair_date,
            tdi.f_handle_date,
            tpim.f_meter_base,--已用气量/金额/字轮数
            tpim.f_aliasname,--表型号
            tpim.f_flow_direction,--表方向
            case when tpim.f_collection_type = '按气量' then tpim.f_total_gas else tpim.f_total_fee end as f_total,--累购金额/累购气量
            ROUND((case when tpim.f_collection_type = '按气量' then tpim.f_total_gas else tpim.f_total_fee end) - tpim.f_meter_base,2) as f_residue,--剩余金额/气量
            u.parentid
        FROM
            t_check_paper tcp
                LEFT JOIN t_paper_devices tpd ON tcp.id= tpd.f_paper_id
                LEFT JOIN t_devices_items tdi ON tpd.id= tdi.f_device_id
                LEFT JOIN t_user usr ON usr.id = tcp.f_checker_id
                left join t_plan_item_meter tpim on tcp.f_check_item_id = tpim.f_plan_item_id
                left join t_user u on tcp.f_checker_id = u.id
        WHERE
                tdi.f_is_defect = 'true'
    ) tt where { condition }
ORDER BY
    f_offsite_time DESC
