SELECT
    f_residential_area,
    SUM(month1) AS month1,
    SUM(month2) AS month2,
    SUM(month3) AS month3,
    SUM(month4) AS month4,
    SUM(month5) AS month5,
    SUM(month6) AS month6,
    SUM(month7) AS month7,
    SUM(month8) AS month8,
    SUM(month9) AS month9,
    SUM(month10) AS month10,
    SUM(month11) AS month11,
    SUM(month12) AS month12,
    COUNT(0) AS countarea
FROM (
         SELECT
             tcpi.f_residential_area,
             CASE WHEN MONTH(tcpi.f_last_check_date) = 1 THEN 1 ELSE 0 END AS month1,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 2 THEN 1 ELSE 0 END AS month2,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 3 THEN 1 ELSE 0 END AS month3,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 4 THEN 1 ELSE 0 END AS month4,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 5 THEN 1 ELSE 0 END AS month5,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 6 THEN 1 ELSE 0 END AS month6,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 7 THEN 1 ELSE 0 END AS month7,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 8 THEN 1 ELSE 0 END AS month8,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 9 THEN 1 ELSE 0 END AS month9,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 10 THEN 1 ELSE 0 END AS month10,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 11 THEN 1 ELSE 0 END AS month11,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 12 THEN 1 ELSE 0 END AS month12
    FROM
        t_check_plan_item tcpi
        LEFT JOIN t_check_plan tcp ON tcpi.f_plan_id = tcp.id
    WHERE {condition} AND tcpi.f_filialeid = {orgid} AND tcpi.f_upload_state = '已传' AND (tcpi.f_last_check_state = '入户' OR (tcpi.f_last_check_state = '到访不遇' AND tcpi.f_check_version >= 3))

    UNION ALL

SELECT
    '申请安检' AS f_residential_area,
    CASE WHEN MONTH(tcpi.f_last_check_date) = 1 THEN 1 ELSE 0 END AS month1,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 2 THEN 1 ELSE 0 END AS month2,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 3 THEN 1 ELSE 0 END AS month3,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 4 THEN 1 ELSE 0 END AS month4,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 5 THEN 1 ELSE 0 END AS month5,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 6 THEN 1 ELSE 0 END AS month6,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 7 THEN 1 ELSE 0 END AS month7,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 8 THEN 1 ELSE 0 END AS month8,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 9 THEN 1 ELSE 0 END AS month9,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 10 THEN 1 ELSE 0 END AS month10,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 11 THEN 1 ELSE 0 END AS month11,
        CASE WHEN MONTH(tcpi.f_last_check_date) = 12 THEN 1 ELSE 0 END AS month12
    FROM
        (SELECT f_offsite_time AS f_last_check_date, f_residential_area, f_check_type AS f_user_type, f_checker_name AS f_checker, f_entry_status FROM t_check_paper where f_no_checkplan='无计划安检') tcpi
    WHERE {condition} AND f_entry_status = '入户'
) subquery
GROUP BY f_residential_area
ORDER BY COUNT(0)
