SELECT
    ui.f_user_name,
    t1.m1_safe,
    t1.m1_remarks,
    t2.m2_safe,
    t2.m2_remarks,
    t3.m3_safe,
    t3.m3_remarks,
    t4.m4_safe,
    t4.m4_remarks
FROM
    t_userinfo ui
        LEFT JOIN t_userfiles uf ON ui.f_userinfo_id = uf.f_userinfo_id and uf.f_table_state in ('正常','停用','待开通')
        LEFT JOIN (
        SELECT
            a.f_userinfoid,
            CASE

                WHEN a.f_offsite_time IS NOT NULL THEN
                    '√' ELSE ''
                END AS m1_safe,
            CASE

                WHEN a.f_offsite_time IS NULL THEN
                    b.f_repair_approved_note ELSE ''
                END AS m1_remarks
        FROM
            (
                SELECT
                    f_userinfoid,
                    MAX ( f_offsite_time ) f_offsite_time
                FROM
                    t_check_paper tcp
                WHERE
                        tcp.f_entry_status = '入户'
                  AND tcp.f_offsite_time >= '{year}-01-01 00:00:00'
                  AND tcp.f_offsite_time <= '{year}-03-31 23:59:59'
                GROUP BY
                    f_userinfoid
            ) a
        LEFT JOIN ( SELECT f_userinfoid, MAX ( f_repair_approved_note ) f_repair_approved_note FROM t_check_paper tcp WHERE tcp.f_offsite_time >= '{year}-01-01 00:00:00' AND tcp.f_offsite_time <= '{year}-03-31 23:59:59' GROUP BY f_userinfoid ) b ON a.f_userinfoid = b.f_userinfoid
    ) t1 ON t1.f_userinfoid = ui.f_userinfo_id
        LEFT JOIN (
        SELECT
            a.f_userinfoid,
            CASE

                WHEN a.f_offsite_time IS NOT NULL THEN
                    '√' ELSE ''
                END AS m2_safe,
            CASE

                WHEN a.f_offsite_time IS NULL THEN
                    b.f_repair_approved_note ELSE ''
                END AS m2_remarks
        FROM
            (
                SELECT
                    f_userinfoid,
                    MAX ( f_offsite_time ) f_offsite_time
                FROM
                    t_check_paper tcp
                WHERE
                        tcp.f_entry_status = '入户'
                  AND tcp.f_offsite_time >= '{year}-04-01 00:00:00'
                  AND tcp.f_offsite_time <= '{year}-06-30 23:59:59'
                GROUP BY
                    f_userinfoid
            ) a
        LEFT JOIN ( SELECT f_userinfoid, MAX ( f_repair_approved_note ) f_repair_approved_note FROM t_check_paper tcp WHERE tcp.f_offsite_time >= '{year}-04-01 00:00:00' AND tcp.f_offsite_time <= '{year}-06-30 23:59:59' GROUP BY f_userinfoid ) b ON a.f_userinfoid = b.f_userinfoid
    ) t2 ON t2.f_userinfoid = ui.f_userinfo_id
        LEFT JOIN (
        SELECT
            a.f_userinfoid,
            CASE

                WHEN a.f_offsite_time IS NOT NULL THEN
                    '√' ELSE ''
                END AS m3_safe,
            CASE

                WHEN a.f_offsite_time IS NULL THEN
                    b.f_repair_approved_note ELSE ''
                END AS m3_remarks
        FROM
            (
                SELECT
                    f_userinfoid,
                    MAX ( f_offsite_time ) f_offsite_time
                FROM
                    t_check_paper tcp
                WHERE
                        tcp.f_entry_status = '入户'
                  AND tcp.f_offsite_time >= '{year}-07-01 00:00:00'
                  AND tcp.f_offsite_time <= '{year}-09-30 23:59:59'
                GROUP BY
                    f_userinfoid
            ) a
        LEFT JOIN ( SELECT f_userinfoid, MAX ( f_repair_approved_note ) f_repair_approved_note FROM t_check_paper tcp WHERE tcp.f_offsite_time >= '{year}-07-01 00:00:00' AND tcp.f_offsite_time <= '{year}-09-30 23:59:59' GROUP BY f_userinfoid ) b ON a.f_userinfoid = b.f_userinfoid
    ) t3 ON t3.f_userinfoid = ui.f_userinfo_id
        LEFT JOIN (
        SELECT
            a.f_userinfoid,
            CASE

                WHEN a.f_offsite_time IS NOT NULL THEN
                    '√' ELSE ''
                END AS m4_safe,
            CASE

                WHEN a.f_offsite_time IS NULL THEN
                    b.f_repair_approved_note ELSE ''
                END AS m4_remarks
        FROM
            (
                SELECT
                    f_userinfoid,
                    MAX ( f_offsite_time ) f_offsite_time
                FROM
                    t_check_paper tcp
                WHERE
                        tcp.f_entry_status = '入户'
                  AND tcp.f_offsite_time >= '{year}-10-01 00:00:00'
                  AND tcp.f_offsite_time <= '{year}-12-31 23:59:59'
                GROUP BY
                    f_userinfoid
            ) a
        LEFT JOIN ( SELECT f_userinfoid, MAX ( f_repair_approved_note ) f_repair_approved_note FROM t_check_paper tcp WHERE tcp.f_offsite_time >= '{year}-10-01 00:00:00' AND tcp.f_offsite_time <= '{year}-12-31 23:59:59' GROUP BY f_userinfoid ) b ON a.f_userinfoid = b.f_userinfoid
    ) t4 ON t4.f_userinfoid = ui.f_userinfo_id
WHERE
    {condition}
order by ui.f_userinfo_id
