SELECT t.*, '' [PROP_AREA_Display], '' [PROP_CQSJ_Display], t1.name [State_Display]
FROM (SELECT ROW_NUMBER() OVER ( ORDER BY AcceptDate desc) AS rownumber,
    [PROP_AREA],
    [PROP_UserAddress],
    [PROP_UserTel],
    [PROP_LXDH],
    [PROP_YHBZ],
    [PROP_SGBZ],
    CONVERT(varchar(20), [PROP_KHRQ], 120)        as [PROP_KHRQ],
    CONVERT(varchar(20), [PROP_AZRQ], 120)        as [PROP_AZRQ],
    CONVERT(varchar(20), [AcceptDate], 120)       as [AcceptDate],
    [AcceptType],
    [CallContent],
    [Acceper],
    [Level],
    [PROP_UserNo],
    [PROP_UserName],
    CONVERT(varchar(20), [PROP_WCQX], 120)        as [PROP_WCQX],
    CONVERT(varchar(20), [PROP_DQTX], 120)        as [PROP_DQTX],
    CONVERT(varchar(20), [PROP_YYRQ], 111)        as [PROP_YYRQ],
    CONVERT(varchar(20), [PROP_YYSJ], 108)        as [PROP_YYSJ],
    CONVERT(varchar(20), [PROP_JDSJ], 120)        as [PROP_JDSJ],
    CONVERT(varchar(20), [PROP_WCSJ], 120)        as [PROP_WCSJ],
    [PROP_CLR],
    [PROP_CLNR],
    [PROP_SFYQ],
    [PROP_YQYY],
    [PROP_YQR],
    [PROP_GCBH],
    CONVERT(varchar(20), [PROP_YQSJ], 120)        as [PROP_YQSJ],
    [PROP_CQSJ],
    [PROP_TQLX],
    [PROP_MPH],
    [PROP_JDR],
    [PROP_JDBM],
    [PROP_LDLX],
    [PROP_SLBM],
    [Name],
    [State],
    [Address],
    [UKID],
    [UserTel],
    [PROP_CallType],
    [ID],
    [Longitude],
    [Latitude],
    [UPID],
    [IOrder],
    0                                             as [childCount],
    [CurrentDept],
    [Creater],
    [CreateDate],
    [Modifier],
    [ModifyDate],
    [ParentCompanyID],
    'equ_icon01.gif'                              as [Icon],
    [FirstFilePath]                                  [FilePath],
    'T_CUS_351'                                      TableName
    FROM T_CUS_351 temp with (nolock)
    WHERE STATE <> '-1'
    AND (ParentCompanyID in
    ('XYGAS', '03', '0301', '0302', '03021', '0303', '0304', '03041', '05', '11', '06', '07', '0701', '0702',
    '070201', '070202', '070203', '070204', '070205', '08', 'khywb', '12', '0121', '13', '131', '14', '141',
    '15', '16', '17', '18', '20') OR ParentCompanyID IS NULL)
    ORDER BY rownumber
    OFFSET (1 - 1) * 100 ROWS FETCH NEXT 100 ROWS ONLY) t
    LEFT JOIN (select Status id, Name
    from T_FORM_FormTableStatus
    where TableName = 'T_CUS_351' and IsNull(isDeleted, 0) = 0) t1
on ISNULL(t1.ID, '') = ISNULL(t.State, '')
ORDER BY rownumber
