SELECT t.*, t1.name [State_Display], t2.name [ParentID_Display]
FROM (SELECT ROW_NUMBER() OVER ( ORDER BY LastReportDate DESC ) AS rownumber,
             [Name],
             [State],
             [Address],
             [ParentID],
             [UserTel],
             [LastReportName],
             CONVERT(varchar(20), [LastReportDate], 120)        as
                                                                   [LastReportDate],
             [PROP_AJQK],
             CONVERT(varchar(20), [PROP_NEXTAJRQ], 111)         as [PROP_NEXTAJRQ],
             [PROP_AJBS],
             [PROP_CQWJ],
             [PROP_BCBDS],
             [FaultCount],
             [PORP_YHDJ],
             [PROP_MPK],
             [PROP_LXR],
             [PROP_SHI],
             [PROP_QU],
             [PROP_JD],
             [PROP_DYH],
             [PROP_LH],
             [PROP_LC],
             [PROP_YHLX],
             [PROP_USERNO],
             [PROP_YHZT],
             CONVERT(varchar(20), [PROP_KHRQ], 111)             as [PROP_KHRQ],
             CONVERT(varchar(20), [PROP_DHRQ], 111)             as [PROP_DHRQ],
             CONVERT(varchar(20), [PROP_TYRQ], 111)             as [PROP_TYRQ],
             [PROP_BPP],
             [PROP_BXH],
             [PROP_BCJ],
             [PROP_BLX],
             [PROP_BH],
             [PROP_ZYB],
             CONVERT(varchar(20), [PROP_BAZRQ], 111)            as [PROP_BAZRQ],
             [PROP_BAZWZ],
             [PROP_DQBLJGQL],
             [PROP_ZLJGQL],
             [PROP_LASTGQL],
             CONVERT(varchar(20), [PROP_LASTGQRQ], 111)         as [PROP_LASTGQRQ],
             [PROP_YQXZ],
             CONVERT(varchar(20), [PROP_BJQAZRQ], 111)          as [PROP_BJQAZRQ],
             [PROP_BDS],
             [PROP_ZGQL],
             [PROP_AJY],
             [PROP_DJ],
             [PROP_XQM],
             [PROP_CZ],
             [PROP_YFK],
             [ID],
             [Longitude],
             [Latitude],
             [UPID],
             [IOrder],
             0                                                  as [childCount],
             [CurrentDept],
             [Creater],
             [CreateDate],
             [Modifier],
             [ModifyDate],
             [ParentCompanyID],
             'equ_icon01.gif'                                   as [Icon],
             [FirstFilePath]                                       [FilePath],
             'T_CUS_310'                                           TableName
      FROM T_CUS_310 temp with (nolock)
      WHERE STATE <> '-1'
        AND (ParentCompanyID in
          ('XYGAS', '03', '0301', '0302', '03021', '0303', '0304', '03041', '05', '11', '06', '07', '0701', '0702',
          '070201', '070202', '070203', '070204', '070205', '08', 'khywb', '12', '0121', '13', '131', '14', '141',
          '15', '16', '17', '18', '20') OR ParentCompanyID IS NULL)
        and CONVERT(varchar(10), [LastReportDate], 111) Between '{startDate}' and '{endDate}'
      ORDER BY rownumber
      OFFSET (1 - 1) * 100 ROWS FETCH NEXT 100 ROWS ONLY) t
         LEFT JOIN (select Status id, Name
                    from T_FORM_FormTableStatus
                    where TableName = 'T_CUS_310' and IsNull(isDeleted, 0) = 0) t1
                   on ISNULL(t1.ID, '') = ISNULL(t.State, '')
         LEFT JOIN (select id, name from T_CUS_309 where state != -1 and state != 3) t2
                   on ISNULL(t2.ID, '') = ISNULL(t.ParentID, '')
ORDER BY rownumber
