select ROW_NUMBER() over (order by ID) as                                    number,
        a.ID,
       Convert(varchar(10), a.CreateDate, 111)                               CreateDate,
       BE.EmployeeName,
       a.Address,
       a.ConType,
       a.Name,
       a.FaultLevel,
       case a.State
           when -1 then '其他'
           else (select Name
                 from T_FORM_FormTableStatus
                 where Status = a.State
                   and TableName = 'T_CUS_101'
                   and ISNULL(IsDeleted, '0') = '0')
           end                         as                                    StateName,
       (select EmployeeName from Bas_Employee where EmployeeID = a.Modifier) LastReportName,
       Convert(varchar(10), a.ModifyDate, 111)                               LastReportDate
from T_CUS_101 a
         INNER JOIN Bas_Employee As BE on BE.EmployeeID = a.Creater
         INNER JOIN fn_GetGroupTree('XYTRQ') AS GroupTree ON GroupTree.GroupID = BE.DeptID
WHERE Convert(varchar(10), a.CreateDate, 111) Between '{startDate}' and '{endDate}'
  And a.ConType in ('道路施工', '管线施工', '电力施工', '通信施工', '建筑施工', '信号灯施工', '装修施工', '其他工地')
  And a.State in (2, 5, 6)
  And (a.Creater = '' or '' = '')
ORDER BY a.ID, a.CreateDate;
