select tt.f_residential_area,             -- 小区
       count(tt.f_userinfo_id) user_count -- 未安检用户数
from (select tua.f_residential_area, ui.f_userinfo_id
      from (select * from t_userinfo where f_open_date < dateadd(year, datediff(year, 0, getdate()), 0)) ui
               left join t_user_address tua on ui.f_userinfo_id = tua.f_userinfo_id
               left join t_userfiles tu on ui.f_userinfo_id = tu.f_userinfo_id
               left join (select * from t_check_plan_item ) cpt
               on cpt.f_userinfoid = ui.f_userinfo_id
               left join (select * from t_check_plan where f_issued = '是' and convert(char(10),f_issue_time,120) = convert(char(10),getdate(),120)) cpl on cpl.id = cpt.f_plan_id
      where ui.f_user_state = '正常'
        and tu.f_table_state = '正常'
        and cpt.id is null
      group by tua.f_residential_area, ui.f_userinfo_id) tt
group by tt.f_residential_area

