SELECT
    *
FROM
    (
        SELECT
            t_temp.*,
            tu.f_gasproperties,
            tu.f_user_type,
            f_meter_book_num,
            f_slice_area,
            f_meter_brand,
            f_meternumber,
            tu.f_table_state,
            f_position,
            ( CASE f_defect_count WHEN 0 THEN '无隐患' ELSE '有隐患' END ) f_has_defect,
            ( CASE f_repair_count WHEN 0 THEN '隐患已处理' ELSE '有隐患' END ) f_is_repair
        FROM
            (
                SELECT
                    cp.id,
                    cp.f_entry_status,
                    cp.f_residential_area,
                    cp.f_user_phone,
                    cp.f_userinfo_code,
                    cp.f_user_name,
                    cp.f_onsite_time,
                    cp.f_offsite_time,
                    cp.f_checker_name,
                    ua.f_address,
                    cp.f_check_plan_id,
                    cpl.f_plan_name,
                    ui.f_userinfo_id,
                    ui.f_filialeid,
                    ui.f_user_state,
                    cp.f_repaired,
                    cp.f_repairman,
                    cp.f_repair_date,
                    cp.f_ratification_des,
                    { f_defect_content } f_defect_content,
                    (
                    SELECT SUM
                    ( CASE di.f_is_defect WHEN 'true' THEN 1 ELSE 0 END ) f_defect_count
                    FROM
                    t_paper_devices pd with (nolock)
                    LEFT JOIN t_devices_items di with (nolock) ON di.f_device_id = pd.id
                    WHERE
                    pd.f_paper_id = cp.id
                    ) f_defect_count,
                    (
                    SELECT SUM
                    ( CASE WHEN dl.f_dealwith IS NULL THEN 0 ELSE 1 END ) f_repair_count
                    FROM
                    t_paper_devices pd with (nolock)
                    LEFT JOIN t_devices_items di with (nolock) ON di.f_device_id = pd.id
                    LEFT JOIN t_devices_items_lists dl with (nolock) ON dl.f_item_id = di.id
                    WHERE
                    pd.f_paper_id = cp.id
                    ) f_repair_count,
                    (
                    SELECT
                    MAX(dl.f_dealer_name)
                    FROM
                    t_paper_devices pd with (nolock)
                    LEFT JOIN t_devices_items di with (nolock) ON di.f_device_id = pd.id
                    LEFT JOIN t_devices_items_lists dl with (nolock) ON dl.f_item_id = di.id
                    WHERE
                    pd.f_paper_id = cp.id
                    ) f_dealer_name,
                    (
                    SELECT
                    MAX(di.id)
                    FROM
                    t_paper_devices pd with (nolock)
                    LEFT JOIN t_devices_items di with (nolock) ON di.f_device_id = pd.id
                    LEFT JOIN t_devices_items_lists dl with (nolock) ON dl.f_item_id = di.id
                    WHERE
                    pd.f_paper_id = cp.id
                    ) f_devive_id
                FROM
                    t_check_paper cp with (nolock)
                    LEFT JOIN t_check_plan cpl  with (nolock) ON cpl.id = cp.f_check_plan_id
                    LEFT JOIN t_userinfo ui with (nolock) ON ui.f_userinfo_id = cp.f_userinfoid
                    LEFT JOIN t_user_address ua with (nolock) ON ua.f_userinfo_id = cp.f_userinfoid
            ) t_temp
                LEFT JOIN t_userfiles tu  with (nolock) ON t_temp.f_userinfo_id = tu.f_userinfo_id
            LEFT JOIN t_gasbrand gb  with (nolock) ON tu.f_gasbrand_id = gb.id
            LEFT JOIN t_user_address tud  with (nolock) ON t_temp.f_userinfo_id = tud.f_userinfo_id
    ) t_temp2
WHERE
    { condition } and f_table_state != '换表'
ORDER BY
    f_offsite_time
