SELECT
    *
FROM
    (
        SELECT
            cpi.id,
            cpi.f_userinfo_code,--客户编号
            cpi.f_userinfoid,--档案编号
            cpi.f_user_name,--用户姓名
            cpi.f_user_type,--用户类型
            cpi.f_user_phone,--用户电话
            cpl.f_plan_year AS f_year,--年
            cpl.f_plan_month AS f_month,--月
            CAST ( cpl.f_plan_year AS VARCHAR ) + '年' + CAST ( cpl.f_plan_month AS VARCHAR ) + '月'  f_plan_month,--计划月份
            cpl.f_plan_name,--计划名称
            cpi.f_no_checkplan,--计划类型
            cpi.f_street,-- 街道
            cpi.f_residential_area,--小区
            cpi.f_address,--用户地址
            cpi.f_state,--是否已检
            CASE

                WHEN cpi.f_state = '已检' THEN
                    cpi.f_last_check_state else ''
                END f_last_check_state,--安检状态
            CASE

                WHEN cpi.f_state = '已检' THEN
                    cpi.f_last_check_date else ''
                END f_last_check_date,--安检时间
            cpi.f_filialeid,--组织id
            ufgb.f_meter_brand,-- 表品牌
            ufgb.f_meternumber,-- 表编号
            ufgb.f_table_state,
            cpi.f_plan_id,
            cpi.f_check_version,
            cpl.f_checker  f_checker_name,--安检员
            CASE

                WHEN cpi.f_last_check_state = '入户' THEN
                    ( CASE WHEN cpi.f_last_check_result LIKE '%正常%' THEN '正常' ELSE '隐患' END ) ELSE '-'
                END f_defect_content,--隐患状态
            f_check_number,--上报条数
            cpi.f_user_type f_usertype,
            cpi.f_checker_namehp,
            case when ti.f_open_date is null then '未开户' else '已开户' end openstate
        FROM
            t_check_plan_item cpi
                LEFT JOIN t_check_plan cpl ON cpi.f_plan_id = cpl.id
                LEFT JOIN ( SELECT f_check_item_id, COUNT ( * ) f_check_number, MAX ( f_offsite_time ) f_offsite_time FROM t_check_paper GROUP BY f_check_item_id ) cp ON cpi.id= cp.f_check_item_id
                left join t_userinfo ti on ti.f_userinfo_id = cpi.f_userinfoid
                LEFT JOIN (
                SELECT
                    f_gasbrand_id,
                    f_meternumber,
                    f_table_state,
                    f_meter_brand,
                    uf.f_userinfo_id
                FROM
                    t_userfiles uf
                        LEFT JOIN t_gasbrand gb ON uf.f_gasbrand_id = gb.id
                WHERE
                        f_table_state IN ( '正常', '停用' )) ufgb ON cpi.f_userinfoid = ufgb.f_userinfo_id
        WHERE
            cpi.f_state!= '作废' and ti.f_user_state != '销户'
    ) s
WHERE
    { condition }
ORDER BY
    id
