SELECT
    f_checker,
    f_checker_id,
    sum( plannum ) plannum,
    sum( no_plan_num ) no_plan_num,
    sum( wrj ) wrj,
    sum( yrj ) yrj,
    sum( ruhu ) ruhu,
    sum( daofang ) daofang,
    sum( jujian ) jujian,
    sum( noruhu ) noruhu,
    sum( nodaofang ) nodaofang,
    sum( nojujian ) nojujian
FROM
    (
        SELECT
            f_checker,
            f_checker_id,
            COUNT( 1 ) AS plannum,
            SUM(
                    isnull( wrj, 0 )) AS wrj,
            SUM(
                    isnull( yrj, 0 )) AS yrj,
            SUM(
                    isnull( ruhu, 0 )) AS ruhu,
            SUM(
                    isnull( daofang, 0 )) AS daofang,
            SUM(
                    isnull( jujian, 0 )) AS jujian,
            0 AS no_plan_num,
            0 AS noruhu,
            0 AS nodaofang,
            0 AS nojujian
        FROM
            (
                SELECT
                    isnull( tcp.f_checker, tt.f_checker_name ) AS f_checker,
                    isnull( tcp.f_checker_id, tt.f_checker_id ) AS f_checker_id,
                    CASE
                        WHEN tcpi.f_state = '未检'
                            OR ( tcpi.f_state = '已检' AND tcpi.F_LAST_CHECK_STATE != '入户' ) THEN
                            1 ELSE 0
                        END AS wrj,
                    CASE
                        WHEN tcpi.f_state = '已检'
                            AND tcpi.F_LAST_CHECK_STATE = '入户' THEN
                            1 ELSE 0
                        END AS yrj,
                    ruhu,
                    daofang,
                    jujian
                FROM
                    (
                        SELECT
                            *
                        FROM
                            t_check_plan
                        WHERE
                            f_filialeid IN { f_filialeids }
                    ) tcp
                    LEFT JOIN ( SELECT * FROM t_check_plan_item WHERE f_filialeid IN { f_filialeids } ) tcpi ON tcp.id = tcpi.f_plan_id
                    LEFT JOIN (
                        SELECT
                            a.*,
                            CASE
                                WHEN f_entry_status = '入户'
                                 THEN
                                    1 ELSE 0
                                END AS ruhu,
                            CASE
                                WHEN f_entry_status = '到访不遇'
                                 THEN
                                    1 ELSE 0
                                END AS daofang,
                            CASE
                                WHEN f_entry_status = '拒检'
                                     THEN
                                    1 ELSE 0
                                END AS jujian
                        FROM
                            t_check_paper a
                                INNER JOIN ( SELECT f_check_item_id, max( f_upload_date ) upload_time FROM t_check_paper GROUP BY f_check_item_id ) b ON a.f_check_item_id = b.f_check_item_id
                                AND b.upload_time = a.f_upload_date
                        WHERE
                            f_filialeid IN { f_filialeids } AND F_NO_CHECKPLAN = '有计划安检' { f_start_time == $$ : $$, $ AND f_offsite_time >= '{f_start_time} 00:00:00' $ } { f_end_time == $$ : $$, $ AND f_offsite_time <= '{f_end_time} 23:59:59' $ }
                        ) tt ON tt.f_check_item_id = tcpi.id
                WHERE
                        1 = 1
                  AND { condition1 }
            ) paper
        WHERE
            f_checker IS NOT NULL { condition3 }
        GROUP BY
            f_checker_id,
            f_checker
UNION ALL
        SELECT
            f_checker,
            f_checker_id,
            0 AS plannum,
            0 AS wrj,
            0 AS yrj,
            0 AS ruhu,
            0 AS daofang,
            0 AS jujian,
            count( t.f_check_item_id ) AS no_plan_num,
            sum( case when rh > 0 then 1 else 0 end ) AS noruhu,
            sum( case when df > 0 and rh = 0 and jj = 0 then 1 else 0 end ) AS nodaofang,
            sum( case when jj > 0 and rh = 0 and df = 0 then 1 else 0 end ) AS nojujian
        FROM
            (
                SELECT
                    f_checker_id,
                    f_check_item_id,
                    f_checker_name AS f_checker,
                    sum( CASE WHEN f_entry_status = '入户' THEN 1 ELSE 0 END ) AS rh,
                    sum( CASE WHEN f_entry_status = '到访不遇' THEN 1 ELSE 0 END ) AS df,
                    sum( CASE WHEN f_entry_status = '拒检' THEN 1 ELSE 0 END ) AS jj
                FROM
                    t_check_paper
                WHERE
                        f_no_checkplan = '无计划安检'
                  AND f_filialeid IN { f_filialeids }
								AND { condition2 }
                GROUP BY
                    f_check_item_id,
                    f_checker_id,
                    f_checker_name
            ) t
        GROUP BY
            f_checker_id,
            f_checker
    ) c
GROUP BY
    f_checker,
    f_checker_id
ORDER BY
    f_checker_id