SELECT f_device_type,
       f_item_value,
       f_defect_level,
       count(*) hiddennum,
       sum(yichuli) yichuli,
       sum(weichuli) weichuli,
       sum(zhuanweixiu) zhuanweixiu
FROM (
         SELECT tpd.f_device_type,
                tdi.f_item_name+':'+tdil.f_item_value  f_item_value,
                isnull(tdi.f_defect_level,'') f_defect_level,
                case when tdi.f_is_repaired = '已处理' then 1 else 0 end yichuli,
                case when tdi.f_is_repaired is null  then 1 else 0 end weichuli,
                case when tdi.f_is_repaired = '转维修' then 1 else 0 end zhuanweixiu
         from t_check_paper tp
                  left join t_userfiles tuf on tp.f_userfiles_id = tuf.f_userfiles_id
                  left join t_gasbrand gb on tuf.f_gasbrand_id = gb.id,
              t_paper_devices tpd,
              t_devices_items tdi,
              t_devices_items_lists tdil,
              t_userinfo tu,
              t_user usr
         WHERE tp.id = tpd.f_paper_id
           and tpd.id = tdi.f_device_id
           and tdi.id = tdil.f_item_id
           and usr.id = tp.f_checker_id
           and tp.f_userinfoid = tu.f_userinfo_id
           and tdi.f_is_defect = 'true'
           and {condition}
             {
             startDate!=$$:$
           and tp.f_offsite_time>='{startDate}' $
             , $$
             }
             {
             endDate!=$$:$
           and tp.f_offsite_time<='{endDate}' $
             , $$
             }
     ) h
GROUP BY h.f_device_type, h.f_item_value, h.f_defect_level
