SELECT
    *
FROM
    (
        SELECT
            tp.ruhuid,
            ui.f_userinfo_id,
            ui.f_createfile_date,
            ui.f_userinfo_code,
            ua.f_street,
            ua.f_residential_area,
            ua.f_building,
            ua.f_unit,
            ua.f_floor,
            ui.f_orgid,
            ua.f_room,
            ua.building,
            ua.unit,
            ua.floor,
            ua.f_pcd_id,
            ua.f_address,
            ui.f_user_name,
            ui.f_user_phone,
            uf.f_meter_book_num,
            uf.f_table_state,
            ua.f_slice_area,
            uf.f_user_type,
            uf.f_meternumber,
            uf.f_meter_brand,
            uf.f_meter_classify,
            uf.f_gasproperties,
            uf.f_gas_date,
            ui.f_last_check_state,
            { f_defect_content } AS f_last_check_result,
            f_defect_content,
            ui.f_comments,
            ua.f_pcd,
            ui.version,
            ui.f_user_state,
            ui.f_filialeid,
            tp.f_checker_name ,
            tp.f_offsite_time f_last_check_date,
            tp.f_checker_name f_last_checker
        FROM
            t_userinfo ui
            left join (
                select
                    (case PATINDEX('%[^0-9]%', f_building)
                    when 0
                    then f_building
                    else 999
                    end
                    ) building,
                    (case PATINDEX('%[^0-9]%', f_unit)
                    when 0
                    then f_unit
                    else 999
                    end
                    ) unit,
                    (case PATINDEX('%[^0-9]%', f_floor)
                    when 0
                    then f_floor
                    else 999
                    end
                    ) floor, *
                from t_user_address
                ) ua on ui.f_userinfo_id = ua.f_userinfo_id
            LEFT JOIN ( SELECT f_user_type,f_meter_book_num,f_userinfo_id,f_meter_classify,f_gasproperties,f_table_state,
            f_meternumber, f_meter_brand,f_gas_date  FROM t_userfiles tu
            left join t_gasbrand gb on tu.f_gasbrand_id = gb.id
            WHERE f_table_state in('正常','停用') ) uf ON ui.f_userinfo_id= uf.f_userinfo_id
            LEFT JOIN (
            SELECT
            id ruhuid ,f_userinfoid,f_offsite_time,f_checker_name,f_entry_status,f_defect_content,f_state
            FROM
            ( SELECT *, ROW_NUMBER () over ( partition BY f_userinfoid ORDER BY f_upload_date  DESC ) AS lastcheck FROM ( SELECT * FROM t_check_paper with (nolock) WHERE { condition.condition2 } ) tp ) t
            WHERE
            lastcheck = 1
            ) tp ON ui.f_userinfo_id = tp.f_userinfoid

    ) a
WHERE
    f_table_state != '无效' and  { condition.condition1 }
ORDER BY
    { orderitem}
